/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.AdminException;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;

class MergeVDBs
extends BaseOperationHandler<VDBRepository> {
    protected MergeVDBs() {
        super("merge-vdbs");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("source-vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("source-vdb-name.missing")));
        }
        if (!operation.hasDefined("source-vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("source-vdb-version.missing")));
        }
        if (!operation.hasDefined("target-vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("target-vdb-name.missing")));
        }
        if (!operation.hasDefined("target-vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("target-vdb-version.missing")));
        }
        String sourceVDBName = operation.get("source-vdb-name").asString();
        int sourceVDBversion = operation.get("source-vdb-version").asInt();
        String targetVDBName = operation.get("target-vdb-name").asString();
        int targetVDBversion = operation.get("target-vdb-version").asInt();
        try {
            repo.mergeVDBs(sourceVDBName, sourceVDBversion, targetVDBName, targetVDBversion);
        }
        catch (AdminException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "source-vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "source-vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "source-vdb-name", "description"}).set(this.getParameterDescription(bundle, "source-vdb-name"));
        operationNode.get(new String[]{"request-properties", "source-vdb-version", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "source-vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "source-vdb-version", "description"}).set(this.getParameterDescription(bundle, "source-vdb-version"));
        operationNode.get(new String[]{"request-properties", "target-vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "target-vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "target-vdb-name", "description"}).set(this.getParameterDescription(bundle, "target-vdb-name"));
        operationNode.get(new String[]{"request-properties", "target-vdb-version", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "target-vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "target-vdb-version", "description"}).set(this.getParameterDescription(bundle, "target-vdb-version"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

