/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ServiceLoader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidAttachments;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TranslatorService;
import org.teiid.logging.LogManager;
import org.teiid.translator.ExecutionFactory;

public final class TranslatorDeployer
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceTarget target = phaseContext.getServiceTarget();
        if (!TeiidAttachments.isTranslator(deploymentUnit)) {
            return;
        }
        String moduleName = deploymentUnit.getName();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader translatorLoader = module.getClassLoader();
        ServiceLoader<ExecutionFactory> serviceLoader = ServiceLoader.load(ExecutionFactory.class, (ClassLoader)translatorLoader);
        if (serviceLoader != null) {
            for (ExecutionFactory ef : serviceLoader) {
                VDBTranslatorMetaData metadata = TranslatorUtil.buildTranslatorMetadata((ExecutionFactory)ef, (String)moduleName);
                if (metadata == null) {
                    throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50070, new Object[]{moduleName}));
                }
                metadata.addAttchment(ClassLoader.class, (Object)translatorLoader);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50006, new Object[]{metadata.getName()}));
                TranslatorService translatorService = new TranslatorService(metadata);
                ServiceBuilder builder = target.addService(TeiidServiceNames.translatorServiceName(metadata.getName()), (Service)translatorService);
                builder.addDependency(TeiidServiceNames.TRANSLATOR_REPO, TranslatorRepository.class, translatorService.repositoryInjector);
                builder.addDependency(TeiidServiceNames.VDB_STATUS_CHECKER, VDBStatusChecker.class, translatorService.statusCheckerInjector);
                builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

