/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.service.ServiceController;
import org.jboss.vfs.VirtualFile;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidAttachments;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.logging.LogManager;
import org.teiid.metadata.index.IndexMetadataStore;

class VDBParserDeployer
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        VirtualFile file = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (TeiidAttachments.isDynamicVDB(deploymentUnit)) {
            this.parseVDBXML(file, deploymentUnit, phaseContext).setDynamic(true);
        } else {
            List childFiles = file.getChildren();
            for (VirtualFile childFile : childFiles) {
                this.scanVDB(childFile, deploymentUnit, phaseContext);
            }
            this.mergeMetaData(deploymentUnit);
        }
    }

    private void scanVDB(VirtualFile file, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        if (file.isDirectory()) {
            List childFiles = file.getChildren();
            for (VirtualFile childFile : childFiles) {
                this.scanVDB(childFile, deploymentUnit, phaseContext);
            }
        } else if (file.getName().toLowerCase().equals("vdb.xml")) {
            this.parseVDBXML(file, deploymentUnit, phaseContext);
        } else if (file.getName().endsWith(".INDEX")) {
            IndexMetadataStore imf = (IndexMetadataStore)deploymentUnit.getAttachment(TeiidAttachments.INDEX_METADATA);
            if (imf == null) {
                imf = new IndexMetadataStore();
                deploymentUnit.putAttachment(TeiidAttachments.INDEX_METADATA, (Object)imf);
            }
            imf.addIndexFile(file);
        } else if (file.getName().toLowerCase().endsWith(".xmi")) {
            UDFMetaData udf = (UDFMetaData)deploymentUnit.getAttachment(TeiidAttachments.UDF_METADATA);
            if (udf == null) {
                udf = new UDFMetaData();
                deploymentUnit.putAttachment(TeiidAttachments.UDF_METADATA, (Object)udf);
            }
            udf.addModelFile(file);
        }
    }

    private VDBMetaData parseVDBXML(VirtualFile file, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        try {
            VDBMetaData vdb = VDBMetadataParser.unmarshell((InputStream)file.openStream());
            ServiceController sc = phaseContext.getServiceRegistry().getService(TeiidServiceNames.OBJECT_SERIALIZER);
            ObjectSerializer serializer = (ObjectSerializer)ObjectSerializer.class.cast(sc.getValue());
            if (serializer.buildVdbXml(vdb).exists()) {
                vdb = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(serializer.buildVdbXml(vdb)));
            }
            deploymentUnit.putAttachment(TeiidAttachments.VDB_METADATA, (Object)vdb);
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB " + file.getName() + " has been parsed."});
            return vdb;
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected VDBMetaData mergeMetaData(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        VDBMetaData vdb = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
        UDFMetaData udf = (UDFMetaData)deploymentUnit.getAttachment(TeiidAttachments.UDF_METADATA);
        IndexMetadataStore imf = (IndexMetadataStore)deploymentUnit.getAttachment(TeiidAttachments.INDEX_METADATA);
        VirtualFile file = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (vdb == null) {
            LogManager.logError((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50016, new Object[]{file.getName()}));
            return null;
        }
        try {
            vdb.setUrl(file.toURL());
            if (imf != null) {
                imf.addEntriesPlusVisibilities(file, vdb);
            }
            if (udf != null) {
                for (Model model : vdb.getModels()) {
                    if (!model.getModelType().equals((Object)Model.Type.FUNCTION)) continue;
                    String path = ((ModelMetaData)model).getPath();
                    if (path == null) {
                        throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50075, new Object[]{model.getName()}));
                    }
                    udf.buildFunctionModelFile(model.getName(), path);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB", file.getName(), "has been parsed."});
        return vdb;
    }
}

