/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import junit.framework.TestCase;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SimplePrincipal;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.jboss.JBossSessionService;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.TeiidLoginContext;

public class TestJBossSessionServiceImpl
extends TestCase {
    private SecurityHelper buildSecurityHelper() throws Exception {
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.stub((Object)p.getName()).toReturn((Object)"alreadylogged");
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(p);
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        SecurityHelper sh = (SecurityHelper)Mockito.mock(SecurityHelper.class);
        Mockito.stub((Object)sh.getSubjectInContext("passthrough")).toReturn((Object)subject);
        return sh;
    }

    public void testAuthenticate() throws Exception {
        Credentials credentials = new Credentials("pass1".toCharArray());
        SecurityHelper ms = this.buildSecurityHelper();
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("testFile");
        HashMap<String, SecurityDomainContext> securityDomainMap = new HashMap<String, SecurityDomainContext>();
        SecurityDomainContext securityContext = (SecurityDomainContext)Mockito.mock(SecurityDomainContext.class);
        AuthenticationManager authManager = new AuthenticationManager(){

            public String getSecurityDomain() {
                return null;
            }

            public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
                return true;
            }

            public boolean isValid(Principal principal, Object credential) {
                return true;
            }

            public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap) {
                return null;
            }

            public Subject getActiveSubject() {
                return null;
            }
        };
        Mockito.stub((Object)securityContext.getAuthenticationManager()).toReturn((Object)authManager);
        securityDomainMap.put("testFile", securityContext);
        JBossSessionService jss = new JBossSessionService(securityDomainMap);
        jss.setSecurityHelper(ms);
        jss.setSecurityDomains(domains);
        TeiidLoginContext c = jss.authenticate("user1", credentials, null, domains, false);
        TestJBossSessionServiceImpl.assertEquals((String)"user1@testFile", (String)c.getUserName());
    }

    public void testPassThrough() throws Exception {
        SecurityHelper ms = this.buildSecurityHelper();
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("passthrough");
        HashMap securityDomainMap = new HashMap();
        JBossSessionService jss = new JBossSessionService(securityDomainMap);
        jss.setSecurityHelper(ms);
        jss.setSecurityDomains(domains);
        TeiidLoginContext c = jss.authenticate("user1", new Credentials("pass1".toCharArray()), null, domains, true);
        TestJBossSessionServiceImpl.assertEquals((String)"alreadylogged@passthrough", (String)c.getUserName());
    }

    public void validateSession(boolean securityEnabled) throws Exception {
        TeiidLoginContext impl = (TeiidLoginContext)Mockito.mock(TeiidLoginContext.class);
        Mockito.stub((Object)impl.getUserName()).toReturn((Object)"steve@somedomain");
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("somedomain");
        HashMap<String, SecurityDomainContext> securityDomainMap = new HashMap<String, SecurityDomainContext>();
        SecurityDomainContext securityContext = (SecurityDomainContext)Mockito.mock(SecurityDomainContext.class);
        AuthenticationManager authManager = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.stub((Object)authManager.isValid((Principal)new SimplePrincipal("steve"), (Object)"pass1", new Subject())).toReturn((Object)true);
        Mockito.stub((Object)securityContext.getAuthenticationManager()).toReturn((Object)authManager);
        securityDomainMap.put("somedomain", securityContext);
        JBossSessionService jss = new JBossSessionService(securityDomainMap);
        jss.setSecurityHelper(this.buildSecurityHelper());
        jss.setSecurityDomains(Arrays.asList("somedomain"));
        try {
            jss.validateSession(String.valueOf(1));
            TestJBossSessionServiceImpl.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
        SessionMetadata info = jss.createSession("steve", new Credentials("pass1".toCharArray()), "foo", new Properties(), true);
        if (securityEnabled) {
            ((AuthenticationManager)Mockito.verify((Object)authManager)).isValid((Principal)new SimplePrincipal("steve"), (Object)"pass1", new Subject());
        }
        String id1 = info.getSessionId();
        jss.validateSession(id1);
        TestJBossSessionServiceImpl.assertEquals((int)1, (int)jss.getActiveSessionsCount());
        TestJBossSessionServiceImpl.assertEquals((int)0, (int)jss.getSessionsLoggedInToVDB("a", 1).size());
        jss.closeSession(id1);
        try {
            jss.validateSession(id1);
            TestJBossSessionServiceImpl.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
        try {
            jss.closeSession(id1);
            TestJBossSessionServiceImpl.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
    }

    @Test
    public void testvalidateSession() throws Exception {
        this.validateSession(true);
    }

    @Test
    public void testvalidateSession2() throws Exception {
        this.validateSession(false);
    }
}

