/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.VDBOperations;

class AssignDataSource
extends VDBOperations {
    public AssignDataSource() {
        super("assign-datasource");
    }

    @Override
    protected void executeOperation(OperationContext context, VDBMetaData vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("model-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("model-name.missing")));
        }
        if (!operation.hasDefined("source-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("source-name.missing")));
        }
        if (!operation.hasDefined("translator-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("translator-name.missing")));
        }
        if (!operation.hasDefined("ds-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("ds-name.missing")));
        }
        String modelName = operation.get("model-name").asString();
        String sourceName = operation.get("source-name").asString();
        String translatorName = operation.get("translator-name").asString();
        String dsName = operation.get("ds-name").asString();
        try {
            ModelMetaData model = vdb.getModel(modelName);
            if (model == null) {
                throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50054, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50054, new Object[]{modelName, vdb.getName(), vdb.getVersion()}));
            }
            SourceMappingMetadata source = model.getSourceMapping(sourceName);
            if (source == null) {
                throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50055, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50055, new Object[]{sourceName, modelName, vdb.getName(), vdb.getVersion()}));
            }
            source.setTranslatorName(translatorName);
            source.setConnectionJndiName(dsName);
            this.save(vdb);
            ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_STATUS_CHECKER);
            VDBStatusChecker vsc = (VDBStatusChecker)VDBStatusChecker.class.cast(sc.getValue());
            vsc.dataSourceReplaced(vdb.getName(), vdb.getVersion(), modelName, sourceName, translatorName, dsName);
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        super.describeParameters(operationNode, bundle);
        operationNode.get(new String[]{"request-properties", "model-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "model-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "model-name", "description"}).set(this.getParameterDescription(bundle, "model-name"));
        operationNode.get(new String[]{"request-properties", "source-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "source-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "source-name", "description"}).set(this.getParameterDescription(bundle, "model-name"));
        operationNode.get(new String[]{"request-properties", "translator-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "translator-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "translator-name", "description"}).set(this.getParameterDescription(bundle, "translator-name"));
        operationNode.get(new String[]{"request-properties", "ds-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "ds-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "ds-name", "description"}).set(this.getParameterDescription(bundle, "ds-name"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

