/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TransportService;

class ListRequestsPerVDB
extends TeiidOperationHandler {
    protected ListRequestsPerVDB() {
        super("list-requests-per-vdb");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-name.missing")));
        }
        if (!operation.hasDefined("vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-version.missing")));
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get("vdb-name").asString();
        int vdbVersion = operation.get("vdb-version").asInt();
        for (TransportService t : this.transports) {
            List<RequestMetadata> requests = t.getRequestsUsingVDB(vdbName, vdbVersion);
            for (RequestMetadata request : requests) {
                VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, result.add());
            }
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.INT);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        VDBMetadataMapper.RequestMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

