/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminException;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;

class TerminateTransaction
extends TeiidOperationHandler {
    protected TerminateTransaction() {
        super("terminate-transaction");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("xid")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("xid.missing")));
        }
        String xid = operation.get("xid").asString();
        try {
            engine.terminateTransaction(xid);
        }
        catch (AdminException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "xid", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "xid", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "xid", "description"}).set(this.getParameterDescription(bundle, "xid"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

