/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossSecurityHelper;
import org.teiid.jboss.JBossSessionService;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.security.SecurityHelper;
import org.teiid.services.SessionServiceImpl;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class TransportService
implements Service<ClientServiceRegistry>,
ClientServiceRegistry {
    private ClientServiceRegistryImpl csr = new ClientServiceRegistryImpl();
    private transient ILogon logon;
    private SocketConfiguration socketConfig;
    final ConcurrentMap<String, SecurityDomainContext> securityDomains = new ConcurrentHashMap<String, SecurityDomainContext>();
    private List<String> authenticationDomains;
    private long sessionMaxLimit;
    private long sessionExpirationTimeLimit;
    private SocketListener socketListener;
    private transient SessionServiceImpl sessionService;
    private AuthenticationType authenticationType;
    private int maxODBCLobSizeAllowed = 0x500000;
    private boolean embedded;
    private String krb5Domain;
    private InetSocketAddress address = null;
    private final InjectedValue<SocketBinding> socketBindingInjector = new InjectedValue();
    private final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    private final InjectedValue<DQPCore> dqpInjector = new InjectedValue();
    private final InjectedValue<BufferManager> bufferManagerInjector = new InjectedValue();

    public <T> T getClientService(Class<T> iface) throws ComponentNotFoundException {
        return (T)this.csr.getClientService(iface);
    }

    public SecurityHelper getSecurityHelper() {
        return this.csr.getSecurityHelper();
    }

    public ClientServiceRegistry getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void waitForFinished(String vdbName, int vdbVersion) {
        VDBRepository repo = (VDBRepository)this.vdbRepositoryInjector.getValue();
        try {
            repo.waitForFinished(vdbName, vdbVersion);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(StartContext context) throws StartException {
        this.csr.setSecurityHelper((SecurityHelper)new JBossSecurityHelper());
        this.sessionService = new JBossSessionService(this.securityDomains);
        if (this.authenticationDomains != null && !this.authenticationDomains.isEmpty()) {
            this.sessionService.setSecurityDomains(this.authenticationDomains);
        }
        this.sessionService.setSessionExpirationTimeLimit(this.sessionExpirationTimeLimit);
        this.sessionService.setSessionMaxLimit(this.sessionMaxLimit);
        this.sessionService.setDqp(this.getDQP());
        this.sessionService.setVDBRepository(this.getVdbRepository());
        this.sessionService.setSecurityHelper(this.csr.getSecurityHelper());
        this.sessionService.setAuthenticationType(this.getAuthenticationType());
        this.sessionService.setGssSecurityDomain(this.krb5Domain);
        this.sessionService.start();
        this.csr.setAuthenticationType(this.sessionService.getAuthenticationType());
        this.logon = new LogonImpl((SessionService)this.sessionService, "teiid-cluster");
        if (this.socketConfig != null) {
            this.address = ((SocketBinding)this.getSocketBindingInjector().getValue()).getSocketAddress();
            Protocol protocol = Protocol.valueOf(this.socketConfig.getProtocol());
            boolean sslEnabled = false;
            if (this.socketConfig.getSSLConfiguration() != null) {
                sslEnabled = this.socketConfig.getSSLConfiguration().isSslEnabled();
            }
            if (protocol == Protocol.teiid) {
                this.socketListener = new SocketListener(this.address, this.socketConfig, this.csr, (StorageManager)this.getBufferManagerInjector().getValue());
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50012, new Object[]{this.address.getHostName(), String.valueOf(this.address.getPort()), sslEnabled ? "ON" : "OFF", this.authenticationDomains}));
            } else {
                if (protocol != Protocol.pg) throw new StartException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50013, new Object[0]));
                this.getVdbRepository().odbcEnabled();
                ODBCSocketListener odbc = new ODBCSocketListener(this.address, this.socketConfig, this.csr, (StorageManager)this.getBufferManagerInjector().getValue(), this.getMaxODBCLobSizeAllowed(), this.logon);
                odbc.setAuthenticationType(this.sessionService.getAuthenticationType());
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50037, new Object[]{this.address.getHostName(), String.valueOf(this.address.getPort()), sslEnabled ? "ON" : "OFF", this.authenticationDomains}));
            }
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50038, new Object[]{"teiid/queryengine"}));
        }
        DQP dqpProxy = (DQP)this.proxyService(DQP.class, this.getDQP(), "org.teiid.PROCESSOR");
        this.csr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        this.csr.registerClientService(DQP.class, (Object)dqpProxy, "org.teiid.PROCESSOR");
    }

    public void stop(StopContext context) {
        if (this.socketListener != null) {
            this.socketListener.stop();
            this.socketListener = null;
        }
        this.sessionService.stop();
        if (this.socketConfig != null) {
            Protocol protocol = Protocol.valueOf(this.socketConfig.getProtocol());
            if (protocol == Protocol.teiid) {
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50039, new Object[]{this.address.getHostName(), String.valueOf(this.address.getPort())}));
            } else if (protocol == Protocol.pg) {
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50040, new Object[]{this.address.getHostName(), String.valueOf(this.address.getPort())}));
            }
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50041, new Object[]{"teiid/queryengine"}));
        }
    }

    private <T> T proxyService(Class<T> iface, T instance, String context) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new LogManager.LoggingProxy(instance, context, 6){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Throwable exception = null;
                try {
                    TransportService.this.sessionService.validateSession(DQPWorkContext.getWorkContext().getSessionId());
                    return super.invoke(proxy, method, args);
                }
                catch (InvocationTargetException e) {
                    exception = e.getTargetException();
                }
                catch (Throwable t) {
                    exception = t;
                }
                throw ExceptionUtil.convertException((Method)method, (Throwable)exception);
            }
        }));
    }

    public List<RequestMetadata> getRequestsUsingVDB(String vdbName, int vdbVersion) {
        ArrayList<RequestMetadata> requests = new ArrayList<RequestMetadata>();
        Collection sessions = this.sessionService.getActiveSessions();
        for (SessionMetadata session : sessions) {
            if (!session.getVDBName().equals(vdbName) || session.getVDBVersion() != vdbVersion) continue;
            requests.addAll(this.getDQP().getRequestsForSession(session.getSessionId()));
        }
        return requests;
    }

    public void terminateSession(String terminateeId) {
        this.sessionService.terminateSession(terminateeId, DQPWorkContext.getWorkContext().getSessionId());
    }

    public Collection<SessionMetadata> getActiveSessions() {
        return this.sessionService.getActiveSessions();
    }

    public int getActiveSessionsCount() throws AdminException {
        try {
            return this.sessionService.getActiveSessionsCount();
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50056, (Throwable)e);
        }
    }

    public InjectedValue<SocketBinding> getSocketBindingInjector() {
        return this.socketBindingInjector;
    }

    public SocketConfiguration getSocketConfig() {
        return this.socketConfig;
    }

    public void setSocketConfig(SocketConfiguration socketConfig) {
        this.socketConfig = socketConfig;
    }

    public List<String> getAuthenticationDomains() {
        return this.authenticationDomains;
    }

    public void setAuthenticationDomains(List<String> authenticationDomains) {
        this.authenticationDomains = new LinkedList<String>(authenticationDomains);
    }

    public void setSessionMaxLimit(long limit) {
        this.sessionMaxLimit = limit;
    }

    public void setSessionExpirationTimeLimit(long limit) {
        this.sessionExpirationTimeLimit = limit;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public InjectedValue<VDBRepository> getVdbRepositoryInjector() {
        return this.vdbRepositoryInjector;
    }

    private VDBRepository getVdbRepository() {
        return (VDBRepository)this.vdbRepositoryInjector.getValue();
    }

    private DQPCore getDQP() {
        return (DQPCore)this.getDqpInjector().getValue();
    }

    public InjectedValue<DQPCore> getDqpInjector() {
        return this.dqpInjector;
    }

    public InjectedValue<BufferManager> getBufferManagerInjector() {
        return this.bufferManagerInjector;
    }

    private int getMaxODBCLobSizeAllowed() {
        return this.maxODBCLobSizeAllowed;
    }

    public void setMaxODBCLobSizeAllowed(int lobSize) {
        this.maxODBCLobSizeAllowed = lobSize;
    }

    public void setEmbedded(boolean v) {
        this.embedded = v;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setKrb5Domain(String domain) {
        this.krb5Domain = domain;
    }

    private static enum Protocol {
        teiid,
        pg;

    }
}

