/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidAttachments;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.VDBService;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.metadata.index.IndexMetadataStore;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.metadata.DDLMetadataRepository;
import org.teiid.query.metadata.NativeMetadataRepository;

class VDBDeployer
implements DeploymentUnitProcessor {
    private static final String DEPLOYMENT_NAME = "deployment-name";
    private static final String JAVA_CONTEXT = "java:/";
    private TranslatorRepository translatorRepository;
    private String asyncThreadPoolName;
    private VDBStatusChecker vdbStatusChecker;
    JBossLifeCycleListener shutdownListener;

    public VDBDeployer(TranslatorRepository translatorRepo, String poolName, VDBStatusChecker vdbStatusChecker, JBossLifeCycleListener shutdownListener) {
        this.translatorRepository = translatorRepo;
        this.asyncThreadPoolName = poolName;
        this.vdbStatusChecker = vdbStatusChecker;
        this.shutdownListener = shutdownListener;
    }

    public void deploy(final DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        List errors;
        boolean preview;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        final VDBMetaData deployment = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
        deployment.addProperty(DEPLOYMENT_NAME, deploymentUnit.getName());
        ServiceController controller = context.getServiceRegistry().getService(TeiidServiceNames.vdbServiceName(deployment.getName(), deployment.getVersion()));
        if (controller != null) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50019, new Object[]{deployment}));
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        if (!(preview = deployment.isPreview()) && (errors = deployment.getValidityErrors()) != null && !errors.isEmpty()) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50074, new Object[]{deployment}));
        }
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            if (!model.isSource() || model.getSourceNames().isEmpty()) continue;
            for (String source : model.getSourceNames()) {
                VDBTranslatorMetaData translator;
                String translatorName = model.getSourceTranslatorName(source);
                if (deployment.isOverideTranslator(translatorName)) {
                    VDBTranslatorMetaData parent = deployment.getTranslator(translatorName);
                    translatorName = parent.getType();
                }
                if ((translator = this.translatorRepository.getTranslatorMetaData(translatorName)) != null) continue;
                String msg = IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50077, new Object[]{translatorName, deployment.getName(), deployment.getVersion()});
                model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), msg);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
            }
        }
        deployment.addAttchment(ClassLoader.class, (Object)((Module)deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader());
        UDFMetaData udf = (UDFMetaData)deploymentUnit.removeAttachment(TeiidAttachments.UDF_METADATA);
        if (udf != null) {
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            if (module != null) {
                udf.setFunctionClassLoader((ClassLoader)module.getClassLoader());
            }
            deployment.addAttchment(UDFMetaData.class, (Object)udf);
        }
        IndexMetadataRepository indexRepo = null;
        IndexMetadataStore indexFactory = (IndexMetadataStore)deploymentUnit.removeAttachment(TeiidAttachments.INDEX_METADATA);
        LinkedHashMap visibilityMap = null;
        if (indexFactory != null) {
            indexRepo = new IndexMetadataRepository(indexFactory);
            visibilityMap = indexFactory.getEntriesPlusVisibilities();
        }
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            if (model.isSource() && model.getSourceNames().isEmpty()) {
                throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50087, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            MetadataRepository repo = this.getMetadataRepository(deployment, model.getName(), indexRepo);
            model.addAttchment(MetadataRepository.class, (Object)repo);
        }
        VDBService vdb = new VDBService(deployment, visibilityMap);
        ServiceBuilder vdbService = context.getServiceTarget().addService(TeiidServiceNames.vdbServiceName(deployment.getName(), deployment.getVersion()), (Service)vdb);
        this.dataSourceDependencies(deployment, new DependentServices(){

            @Override
            public void dependentService(String dsName, ServiceName svcName) {
                DataSourceListener dsl = new DataSourceListener(dsName, svcName, VDBDeployer.this.vdbStatusChecker);
                ServiceBuilder sb = context.getServiceTarget().addService(TeiidServiceNames.dsListenerServiceName(deployment.getName(), deployment.getVersion(), dsName), (Service)dsl);
                sb.addDependency(svcName);
                sb.setInitialMode(ServiceController.Mode.PASSIVE).install();
            }
        });
        for (VDBImportMetadata vdbImport : deployment.getVDBImports()) {
            vdbService.addDependency(TeiidServiceNames.vdbFinishedServiceName(vdbImport.getName(), vdbImport.getVersion()));
        }
        for (Model model : deployment.getModels()) {
            List sourceNames = model.getSourceNames();
            for (String sourceName : sourceNames) {
                String translatorName = model.getSourceTranslatorName(sourceName);
                if (deployment.isOverideTranslator(translatorName)) {
                    VDBTranslatorMetaData translator = deployment.getTranslator(translatorName);
                    translatorName = translator.getType();
                }
                vdbService.addDependency(TeiidServiceNames.translatorServiceName(translatorName));
            }
        }
        vdbService.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, vdb.vdbRepositoryInjector);
        vdbService.addDependency(TeiidServiceNames.TRANSLATOR_REPO, TranslatorRepository.class, vdb.translatorRepositoryInjector);
        vdbService.addDependency(TeiidServiceNames.executorServiceName(this.asyncThreadPoolName), Executor.class, vdb.executorInjector);
        vdbService.addDependency(TeiidServiceNames.OBJECT_SERIALIZER, ObjectSerializer.class, vdb.serializerInjector);
        vdbService.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, vdb.bufferManagerInjector);
        vdbService.addDependency(ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, vdb.objectReplicatorInjector);
        vdbService.setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private void dataSourceDependencies(VDBMetaData deployment, DependentServices svcListener) {
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            for (String sourceName : model.getSourceNames()) {
                String translatorName = model.getSourceTranslatorName(sourceName);
                if (deployment.isOverideTranslator(translatorName)) {
                    VDBTranslatorMetaData translator = deployment.getTranslator(translatorName);
                    translatorName = translator.getType();
                }
                String dsName = model.getSourceConnectionJndiName(sourceName);
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)this.getJndiName(dsName));
                svcListener.dependentService(dsName, bindInfo.getBinderServiceName());
            }
        }
    }

    private String getJndiName(String name) {
        String jndiName = name;
        if (!name.startsWith(JAVA_CONTEXT)) {
            jndiName = JAVA_CONTEXT + jndiName;
        }
        return jndiName;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        if (!this.shutdownListener.isShutdownInProgress()) {
            VDBMetaData vdb = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
            ServiceController sc = deploymentUnit.getServiceRegistry().getService(TeiidServiceNames.OBJECT_SERIALIZER);
            if (sc != null) {
                ObjectSerializer serilalizer = (ObjectSerializer)ObjectSerializer.class.cast(sc.getValue());
                serilalizer.removeAttachments(vdb);
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB " + vdb.getName() + " metadata removed"});
            }
        }
    }

    private MetadataRepository getMetadataRepository(VDBMetaData vdb, String modelName, IndexMetadataRepository indexRepo) throws DeploymentUnitProcessingException {
        ModelMetaData model = vdb.getModel(modelName);
        if (model.getSchemaSourceType() == null) {
            if (!vdb.isDynamic()) {
                return indexRepo;
            }
            if (vdb.isDynamic() && model.isSource()) {
                return new NativeMetadataRepository();
            }
            return null;
        }
        DDLMetadataRepository first = null;
        Object current = null;
        DDLMetadataRepository previous = null;
        StringTokenizer st = new StringTokenizer(model.getSchemaSourceType(), ",");
        while (st.hasMoreTokens()) {
            String repoType = st.nextToken().trim();
            current = repoType.equalsIgnoreCase("DDL") ? new DDLMetadataRepository() : (repoType.equalsIgnoreCase("INDEX") ? indexRepo : (repoType.equalsIgnoreCase("NATIVE") ? new NativeMetadataRepository() : this.getModuleBasedMetadataRepository(repoType)));
            if (current == null) continue;
            if (first == null) {
                first = current;
            }
            if (previous != null) {
                previous.setNext((MetadataRepository)current);
            }
            previous = current;
            current = null;
        }
        return first;
    }

    private MetadataRepository getModuleBasedMetadataRepository(String moduleName) throws DeploymentUnitProcessingException {
        Iterator<MetadataRepository> i$;
        ServiceLoader<MetadataRepository> serviceLoader;
        ClassLoader moduleLoader = this.getClass().getClassLoader();
        ModuleLoader ml = Module.getCallerModuleLoader();
        if (moduleName != null && ml != null) {
            try {
                Module module = ml.loadModule(ModuleIdentifier.create((String)moduleName));
                moduleLoader = module.getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50057, new Object[]{moduleName}));
            }
        }
        if ((serviceLoader = ServiceLoader.load(MetadataRepository.class, moduleLoader)) != null && (i$ = serviceLoader.iterator()).hasNext()) {
            MetadataRepository loader = i$.next();
            return loader;
        }
        return null;
    }

    static class DataSourceListener
    implements Service<DataSourceListener> {
        private VDBStatusChecker vdbStatusChecker;
        private String dsName;
        private ServiceName svcName;

        public DataSourceListener(String dsName, ServiceName svcName, VDBStatusChecker checker) {
            this.dsName = dsName;
            this.svcName = svcName;
            this.vdbStatusChecker = checker;
        }

        public DataSourceListener getValue() throws IllegalStateException, IllegalArgumentException {
            return this;
        }

        public void start(StartContext context) throws StartException {
            ServiceController s = context.getController().getServiceContainer().getService(this.svcName);
            if (s != null) {
                this.vdbStatusChecker.dataSourceAdded(this.dsName);
            }
        }

        public void stop(StopContext context) {
            ServiceController s = context.getController().getServiceContainer().getService(this.svcName);
            if (s.getMode().equals((Object)ServiceController.Mode.REMOVE) || s.getState().equals((Object)ServiceController.State.STOPPING)) {
                this.vdbStatusChecker.dataSourceRemoved(this.dsName);
            }
        }
    }

    static interface DependentServices {
        public void dependentService(String var1, ServiceName var2);
    }
}

