/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidServiceNames;

abstract class VDBOperations
extends BaseOperationHandler<VDBMetaData> {
    private ObjectSerializer serializer;

    public VDBOperations(String operationName) {
        super(operationName);
    }

    @Override
    public VDBMetaData getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-name.missing")));
        }
        if (!operation.hasDefined("vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-version.missing")));
        }
        String vdbName = operation.get("vdb-name").asString();
        int vdbVersion = operation.get("vdb-version").asInt();
        ServiceController osSvc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.OBJECT_SERIALIZER);
        this.serializer = (ObjectSerializer)ObjectSerializer.class.cast(osSvc.getValue());
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.vdbServiceName(vdbName, vdbVersion));
        return (VDBMetaData)VDBMetaData.class.cast(sc.getValue());
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
    }

    protected void save(VDBMetaData vdb) throws AdminProcessingException {
        try {
            VDBMetadataParser.marshell((VDBMetaData)vdb, (OutputStream)this.serializer.getVdbXmlOutputStream(vdb));
        }
        catch (IOException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50048, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50049, (Throwable)e);
        }
    }
}

