/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.translator.DelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

class VDBService
implements Service<VDBMetaData> {
    private VDBMetaData vdb;
    protected final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    protected final InjectedValue<TranslatorRepository> translatorRepositoryInjector = new InjectedValue();
    protected final InjectedValue<Executor> executorInjector = new InjectedValue();
    protected final InjectedValue<ObjectSerializer> serializerInjector = new InjectedValue();
    protected final InjectedValue<BufferManager> bufferManagerInjector = new InjectedValue();
    protected final InjectedValue<ObjectReplicator> objectReplicatorInjector = new InjectedValue();
    private VDBLifeCycleListener vdbListener;
    private LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap;

    public VDBService(VDBMetaData metadata, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap) {
        this.vdb = metadata;
        this.visibilityMap = visibilityMap;
    }

    public void start(StartContext context) throws StartException {
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        TranslatorRepository repo = new TranslatorRepository();
        this.vdb.addAttchment(TranslatorRepository.class, (Object)repo);
        UDFMetaData udf = (UDFMetaData)this.vdb.getAttachment(UDFMetaData.class);
        for (Translator t : this.vdb.getOverrideTranslators()) {
            VDBTranslatorMetaData data = (VDBTranslatorMetaData)t;
            String type = data.getType();
            VDBTranslatorMetaData parent = this.getTranslatorRepository().getTranslatorMetaData(type);
            data.setModuleName(parent.getModuleName());
            data.addAttchment(ClassLoader.class, parent.getAttachment(ClassLoader.class));
            Set<String> keys = parent.getProperties().stringPropertyNames();
            for (String key : keys) {
                if (data.getPropertyValue(key) != null || parent.getPropertyValue(key) == null) continue;
                data.addProperty(key, parent.getPropertyValue(key));
            }
            repo.addTranslatorMetadata(data.getName(), data);
        }
        this.createConnectorManagers(cmr, repo, this.vdb);
        final ServiceBuilder<Void> vdbService = this.addVDBFinishedService(context);
        this.vdbListener = new VDBLifeCycleListener(){

            public void added(String name, int version, CompositeVDB vdb) {
            }

            public void removed(String name, int version, CompositeVDB vdb) {
            }

            public void finishedDeployment(String name, int version, CompositeVDB vdb) {
                if (!name.equals(VDBService.this.vdb.getName()) || version != VDBService.this.vdb.getVersion()) {
                    return;
                }
                VDBMetaData vdbInstance = vdb.getVDB();
                GlobalTableStoreImpl gts = new GlobalTableStoreImpl(VDBService.this.getBuffermanager(), (QueryMetadataInterface)vdbInstance.getAttachment(TransformationMetadata.class));
                if (VDBService.this.objectReplicatorInjector.getValue() != null) {
                    try {
                        gts = (GlobalTableStore)((ObjectReplicator)VDBService.this.objectReplicatorInjector.getValue()).replicate(name + version, GlobalTableStore.class, (Object)gts, 300000L);
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50023, new Object[]{gts}));
                    }
                }
                vdbInstance.addAttchment(GlobalTableStore.class, (Object)gts);
                vdbService.install();
            }
        };
        this.getVDBRepository().addListener(this.vdbListener);
        MetadataStore store = new MetadataStore();
        try {
            this.getVDBRepository().addVDB(this.vdb, store, this.visibilityMap, udf, cmr);
        }
        catch (VirtualDatabaseException e) {
            throw new StartException(IntegrationPlugin.Event.TEIID50032.name(), (Throwable)e);
        }
        this.vdb.removeAttachment(UDFMetaData.class);
        AtomicInteger loadCount = new AtomicInteger(this.vdb.getModelMetaDatas().values().size());
        for (ModelMetaData model : this.vdb.getModelMetaDatas().values()) {
            MetadataRepository metadataRepository = (MetadataRepository)model.getAttachment(MetadataRepository.class);
            if (metadataRepository == null) {
                throw new StartException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50086, new Object[]{model.getName(), this.vdb.getName(), this.vdb.getVersion()}));
            }
            model.addAttchment(MetadataRepository.class, (Object)metadataRepository);
            if (model.getModelType() == Model.Type.PHYSICAL || model.getModelType() == Model.Type.VIRTUAL) {
                this.loadMetadata(this.vdb, model, cmr, metadataRepository, store, loadCount);
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", this.vdb.getName(), " was being loaded from its repository in separate thread"});
                continue;
            }
            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", this.vdb.getName(), " skipped being loaded because of its type ", model.getModelType()});
        }
    }

    private ServiceBuilder<Void> addVDBFinishedService(StartContext context) {
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ServiceController controller = serviceContainer.getService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        return serviceContainer.addService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()), (Service)new Service<Void>(){

            public Void getValue() throws IllegalStateException, IllegalArgumentException {
                return null;
            }

            public void start(StartContext context) throws StartException {
            }

            public void stop(StopContext context) {
            }
        });
    }

    public void stop(StopContext context) {
        ServiceController controller;
        if (this.objectReplicatorInjector.getValue() != null) {
            GlobalTableStore gts = (GlobalTableStore)this.vdb.getAttachment(GlobalTableStore.class);
            ((ObjectReplicator)this.objectReplicatorInjector.getValue()).stop((Object)gts);
        }
        this.getVDBRepository().removeListener(this.vdbListener);
        VDBMetaData runtimeMetadata = this.getVDBRepository().removeVDB(this.vdb.getName(), this.vdb.getVersion());
        if (runtimeMetadata != null) {
            runtimeMetadata.setStatus(VDB.Status.REMOVED);
        }
        if ((controller = context.getController().getServiceContainer().getService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()))) != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50026, new Object[]{this.vdb}));
    }

    public VDBMetaData getValue() throws IllegalStateException, IllegalArgumentException {
        return this.vdb;
    }

    private void createConnectorManagers(ConnectorManagerRepository cmr, final TranslatorRepository repo, final VDBMetaData deployment) throws StartException {
        final IdentityHashMap map = new IdentityHashMap();
        try {
            cmr.createConnectorManagers(deployment, new ConnectorManagerRepository.ExecutionFactoryProvider(){

                public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
                    return VDBService.getExecutionFactory(name, repo, VDBService.this.getTranslatorRepository(), deployment, map, new HashSet<String>());
                }
            });
        }
        catch (ConnectorManagerRepository.ConnectorManagerException e) {
            if (e.getCause() != null) {
                throw new StartException(IntegrationPlugin.Event.TEIID50035.name() + " " + e.getMessage(), e.getCause());
            }
            throw new StartException(e.getMessage());
        }
    }

    static ExecutionFactory<Object, Object> getExecutionFactory(String name, TranslatorRepository vdbRepo, TranslatorRepository repo, VDBMetaData deployment, IdentityHashMap<Translator, ExecutionFactory<Object, Object>> map, HashSet<String> building) throws ConnectorManagerRepository.ConnectorManagerException {
        if (!building.add(name)) {
            throw new ConnectorManagerRepository.ConnectorManagerException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50076, new Object[]{deployment.getName(), deployment.getVersion(), building}));
        }
        VDBTranslatorMetaData translator = vdbRepo.getTranslatorMetaData(name);
        if (translator == null) {
            translator = repo.getTranslatorMetaData(name);
        }
        if (translator == null) {
            throw new ConnectorManagerRepository.ConnectorManagerException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50078, new Object[]{deployment.getName(), deployment.getVersion(), name}));
        }
        try {
            ExecutionFactory ef = map.get(translator);
            if (ef == null) {
                DelegatingExecutionFactory delegator;
                String delegateName;
                ClassLoader classloader = (ClassLoader)translator.getAttachment(ClassLoader.class);
                if (classloader == null) {
                    classloader = Thread.currentThread().getContextClassLoader();
                }
                if ((ef = TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)translator, (ClassLoader)classloader)) instanceof DelegatingExecutionFactory && (delegateName = (delegator = (DelegatingExecutionFactory)ef).getDelegateName()) != null) {
                    ExecutionFactory<Object, Object> delegate = VDBService.getExecutionFactory(delegateName, vdbRepo, repo, deployment, map, building);
                    ((DelegatingExecutionFactory)ef).setDelegate(delegate);
                }
                map.put((Translator)translator, (ExecutionFactory<Object, Object>)ef);
            }
            return ef;
        }
        catch (TeiidException e) {
            throw new ConnectorManagerRepository.ConnectorManagerException((Throwable)e);
        }
    }

    private boolean loadMetadata(final VDBMetaData vdb, final ModelMetaData model, final ConnectorManagerRepository cmr, final MetadataRepository metadataRepo, final MetadataStore vdbMetadataStore, final AtomicInteger loadCount) {
        String msg = IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50029, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())});
        model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), msg);
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
        boolean asynch = false;
        Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean metadataLoaded = false;
                boolean cached = false;
                ArrayList<String> errorMessages = new ArrayList<String>();
                File cachedFile = VDBService.this.getSerializer().buildModelFile(vdb, model.getName());
                MetadataFactory factory = VDBService.this.getSerializer().loadSafe(cachedFile, MetadataFactory.class);
                if (factory != null) {
                    metadataLoaded = true;
                    cached = true;
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " was loaded from cached metadata"});
                }
                if (!metadataLoaded) {
                    boolean indexStore = metadataRepo instanceof IndexMetadataRepository;
                    Map datatypes = indexStore ? VDBService.this.getVDBRepository().getSystemStore().getDatatypes() : VDBService.this.getVDBRepository().getBuiltinDatatypes();
                    factory = new MetadataFactory(vdb.getName(), vdb.getVersion(), model.getName(), datatypes, model.getProperties(), model.getSchemaText());
                    factory.getSchema().setPhysical(model.isSource());
                    ExecutionFactory ef = null;
                    Object cf = null;
                    try {
                        ConnectorManager cm = VDBService.this.getConnectorManager(model, cmr);
                        ef = cm == null ? null : cm.getExecutionFactory();
                        cf = cm == null ? null : cm.getConnectionFactory();
                    }
                    catch (TranslatorException e1) {
                        // empty catch block
                    }
                    try {
                        metadataRepo.loadMetadata(factory, ef, cf);
                        model.setSchemaText(null);
                        metadataLoaded = true;
                        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50030, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())}));
                    }
                    catch (TranslatorException e) {
                        errorMessages.add(e.getMessage());
                        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50036, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), e.getMessage()}));
                    }
                }
                VDBMetaData vDBMetaData = vdb;
                synchronized (vDBMetaData) {
                    if (metadataLoaded) {
                        if (!cached) {
                            VDBService.this.cacheMetadataStore(model, factory);
                        }
                        factory.mergeInto(vdbMetadataStore);
                        model.clearErrors();
                        if (loadCount.decrementAndGet() == 0) {
                            VDBService.this.getVDBRepository().finishDeployment(vdb.getName(), vdb.getVersion());
                        }
                    } else {
                        for (String errorMsg : errorMessages) {
                            model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), errorMsg);
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)errorMsg);
                        }
                    }
                }
                if (!metadataLoaded) {
                    model.addAttchment(Runnable.class, (Object)this);
                }
            }
        };
        Executor executor = this.getExecutor();
        if (executor == null) {
            job.run();
        } else {
            asynch = true;
            executor.execute(job);
        }
        return asynch;
    }

    private ConnectorManager getConnectorManager(ModelMetaData model, ConnectorManagerRepository cmr) {
        List mappings;
        Iterator i$;
        if (model.isSource() && (i$ = (mappings = model.getSourceMappings()).iterator()).hasNext()) {
            SourceMappingMetadata mapping = (SourceMappingMetadata)i$.next();
            return cmr.getConnectorManager(mapping.getName());
        }
        return null;
    }

    private void cacheMetadataStore(ModelMetaData model, MetadataFactory schema) {
        boolean cache;
        boolean bl = cache = !this.vdb.isDynamic();
        if (this.vdb.isDynamic()) {
            cache = "cached".equalsIgnoreCase(this.vdb.getPropertyValue("UseConnectorMetadata"));
        }
        if (cache) {
            File cachedFile = this.getSerializer().buildModelFile(this.vdb, model.getName());
            try {
                this.getSerializer().saveAttachment(cachedFile, schema, false);
            }
            catch (IOException e) {
                LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50044, new Object[]{this.vdb.getName(), this.vdb.getVersion(), model.getName()}));
            }
        }
    }

    private VDBRepository getVDBRepository() {
        return (VDBRepository)this.vdbRepositoryInjector.getValue();
    }

    private TranslatorRepository getTranslatorRepository() {
        return (TranslatorRepository)this.translatorRepositoryInjector.getValue();
    }

    private Executor getExecutor() {
        return (Executor)this.executorInjector.getValue();
    }

    private ObjectSerializer getSerializer() {
        return (ObjectSerializer)this.serializerInjector.getValue();
    }

    private BufferManager getBuffermanager() {
        return (BufferManager)this.bufferManagerInjector.getValue();
    }

    public void addDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        DataPolicyMetadata policy = VDBService.getPolicy(this.vdb, policyName);
        policy.addMappedRoleName(mappedRole);
        this.save();
    }

    public void remoteDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        DataPolicyMetadata policy = VDBService.getPolicy(this.vdb, policyName);
        policy.removeMappedRoleName(mappedRole);
        this.save();
    }

    public void addAnyAuthenticated(String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = VDBService.getPolicy(this.vdb, policyName);
        policy.setAnyAuthenticated(true);
        this.save();
    }

    public void removeAnyAuthenticated(String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = VDBService.getPolicy(this.vdb, policyName);
        policy.setAnyAuthenticated(false);
        this.save();
    }

    public void changeConnectionType(VDB.ConnectionType type) throws AdminProcessingException {
        this.vdb.setConnectionType(type);
        this.save();
    }

    public void assignDatasource(String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        ModelMetaData model = this.vdb.getModel(modelName);
        if (model == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50062, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50062, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        SourceMappingMetadata source = model.getSourceMapping(sourceName);
        if (source == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50063, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50063, new Object[]{sourceName, modelName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        source.setTranslatorName(translatorName);
        source.setConnectionJndiName(dsName);
        this.save();
    }

    private void save() throws AdminProcessingException {
        try {
            ObjectSerializer os = this.getSerializer();
            VDBMetadataParser.marshell((VDBMetaData)this.vdb, (OutputStream)os.getVdbXmlOutputStream(this.vdb));
        }
        catch (IOException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50064, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50065, (Throwable)e);
        }
    }

    static DataPolicyMetadata getPolicy(VDBMetaData vdb, String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = vdb.getDataPolicy(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50051, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50051, new Object[]{policyName, vdb.getName(), vdb.getVersion()}));
        }
        return policy;
    }
}

