/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.client.plan.PlanNode;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;

class GetPlan
extends TeiidOperationHandler {
    protected GetPlan() {
        super("get-query-plan");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("session")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("session.missing")));
        }
        if (!operation.hasDefined("execution-id")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("execution-id.missing")));
        }
        PlanNode plan = engine.getPlan(operation.get("session").asString(), operation.get("execution-id").asLong());
        ModelNode result = context.getResult();
        result.set(plan.toXml());
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "session", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "session", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "session", "description"}).set(this.getParameterDescription(bundle, "session"));
        operationNode.get(new String[]{"request-properties", "execution-id", "type"}).set(ModelType.LONG);
        operationNode.get(new String[]{"request-properties", "execution-id", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "execution-id", "description"}).set(this.getParameterDescription(bundle, "execution-id"));
        operationNode.get("reply-properties").get("type").set(ModelType.STRING);
    }
}

