/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.logging.Logger;

public class JBossLogger
implements org.teiid.logging.Logger {
    public boolean isEnabled(String context, int level) {
        if (context == null) {
            return false;
        }
        Logger.Level logLevel = JBossLogger.convert2JbossLevel(level);
        Logger log = this.getLogger(context);
        return log.isEnabled(logLevel);
    }

    public void log(int level, String context, Object msg) {
        Logger logger = this.getLogger(context);
        logger.log(JBossLogger.convert2JbossLevel(level), msg);
    }

    public void log(int level, String context, Throwable t, Object msg) {
        Logger logger = this.getLogger(context);
        logger.log(JBossLogger.convert2JbossLevel(level), msg, t);
    }

    public static Logger.Level convert2JbossLevel(int level) {
        switch (level) {
            case 1: {
                return Logger.Level.FATAL;
            }
            case 2: {
                return Logger.Level.ERROR;
            }
            case 3: {
                return Logger.Level.WARN;
            }
            case 4: {
                return Logger.Level.INFO;
            }
            case 5: {
                return Logger.Level.DEBUG;
            }
            case 6: {
                return Logger.Level.TRACE;
            }
        }
        return Logger.Level.DEBUG;
    }

    public static int convert2MessageLevel(Logger.Level level) {
        switch (level) {
            case FATAL: {
                return 1;
            }
            case ERROR: {
                return 2;
            }
            case WARN: {
                return 3;
            }
            case INFO: {
                return 4;
            }
            case DEBUG: {
                return 5;
            }
            case TRACE: {
                return 0;
            }
        }
        return 5;
    }

    private Logger getLogger(String context) {
        return Logger.getLogger((String)context);
    }

    public void shutdown() {
    }
}

