/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.replication.jboss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Buffer;
import org.jgroups.util.Promise;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.teiid.Replicated;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ObjectInputStreamWithClassloader;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.ReplicatedObject;
import org.teiid.replication.jboss.AddressWrapper;
import org.teiid.replication.jboss.JGroupsInputStream;
import org.teiid.replication.jboss.JGroupsOutputStream;

public class JGroupsObjectReplicator
implements ObjectReplicator,
Serializable {
    private static final int IO_TIMEOUT = 15000;
    private static final long serialVersionUID = -6851804958313095166L;
    private static final String HAS_STATE = "hasState";
    private static final String SEND_STATE = "sendState";
    private static final String CREATE_STATE = "createState";
    private static final String BUILD_STATE = "buildState";
    private static final String FINISH_STATE = "finishState";
    private transient Executor executor = Executors.newCachedThreadPool();
    private transient ChannelFactory channelFactory;

    public JGroupsObjectReplicator(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public void stop(Object object) {
        if (object == null || !Proxy.isProxyClass(object.getClass())) {
            return;
        }
        ReplicatedInvocationHandler handler = (ReplicatedInvocationHandler)Proxy.getInvocationHandler(object);
        Channel c = handler.disp.getChannel();
        handler.disp.stop();
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, S> T replicate(String mux_id, Class<T> iface, S object, long startTimeout) throws Exception {
        Channel channel = this.channelFactory.createChannel(mux_id);
        TreeMap<String, Method> methods = new TreeMap<String, Method>();
        for (Method method : iface.getMethods()) {
            if (method.getAnnotation(Replicated.class) == null) continue;
            methods.put(method.toGenericString(), method);
        }
        HashMap<Object, Short> methodMap = new HashMap<Object, Short>();
        final ArrayList<Object> methodList = new ArrayList<Object>();
        for (String string : methods.keySet()) {
            methodList.add(methods.get(string));
            methodMap.put(methods.get(string), (short)(methodList.size() - 1));
        }
        Method hasState = ReplicatedObject.class.getMethod(HAS_STATE, Serializable.class);
        methodList.add(hasState);
        methodMap.put(hasState, (short)(methodList.size() - 1));
        Method method = Streaming.class.getMethod(SEND_STATE, Serializable.class, AddressWrapper.class);
        methodList.add(method);
        methodMap.put(method, (short)(methodList.size() - 1));
        Method createState = Streaming.class.getMethod(CREATE_STATE, Serializable.class);
        methodList.add(createState);
        methodMap.put(createState, (short)(methodList.size() - 1));
        Method buildState = Streaming.class.getMethod(BUILD_STATE, Serializable.class, byte[].class);
        methodList.add(buildState);
        methodMap.put(buildState, (short)(methodList.size() - 1));
        Method finishState = Streaming.class.getMethod(FINISH_STATE, Serializable.class);
        methodList.add(finishState);
        methodMap.put(finishState, (short)(methodList.size() - 1));
        ReplicatedInvocationHandler proxy = new ReplicatedInvocationHandler(object, methodMap);
        ReplicatorRpcDispatcher disp = new ReplicatorRpcDispatcher(channel, (MessageListener)proxy, (MembershipListener)proxy, object, object, methodMap, methodList);
        proxy.setDisp(disp);
        disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return (Method)methodList.get(id);
            }
        });
        Object replicatedProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, proxy);
        boolean success = false;
        try {
            channel.connect(mux_id);
            if (object instanceof ReplicatedObject) {
                ((ReplicatedObject)object).setAddress((Serializable)new AddressWrapper(channel.getAddress()));
                proxy.pullState(null, null, null, startTimeout);
            }
            success = true;
            Object object2 = replicatedProxy;
            return (T)object2;
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new TeiidRuntimeException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50067, e);
        }
        finally {
            if (!success) {
                channel.close();
            } else {
                ReplicatorRpcDispatcher replicatorRpcDispatcher = disp;
                synchronized (replicatorRpcDispatcher) {
                    disp.initialized = true;
                }
            }
        }
    }

    static class ContextAwareMarshaller
    implements RpcDispatcher.Marshaller {
        private ClassLoader classloader;

        public ContextAwareMarshaller(ClassLoader classloader) {
            this.classloader = classloader;
        }

        public Buffer objectToBuffer(Object obj) throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.close();
            return new Buffer(baos.toByteArray());
        }

        public Object objectFromBuffer(byte[] buf, int offset, int length) throws Exception {
            ObjectInputStreamWithClassloader in = new ObjectInputStreamWithClassloader((InputStream)new ByteArrayInputStream(buf, offset, length), this.classloader);
            Object anObj = in.readObject();
            in.close();
            return anObj;
        }
    }

    private static interface Streaming {
        public void sendState(Serializable var1, AddressWrapper var2);

        public void createState(Serializable var1);

        public void buildState(Serializable var1, byte[] var2);

        public void finishState(Serializable var1);
    }

    private final class ReplicatedInvocationHandler<S>
    extends ReceiverAdapter
    implements InvocationHandler,
    Serializable {
        private static final int PULL_RETRIES = 3;
        private static final long serialVersionUID = -2943462899945966103L;
        private final S object;
        private transient ReplicatorRpcDispatcher<S> disp;
        private final HashMap<Method, Short> methodMap;
        protected List<Address> remoteMembers = Collections.synchronizedList(new ArrayList());
        private Map<Serializable, Promise<Boolean>> loadingStates = new HashMap<Serializable, Promise<Boolean>>();

        private ReplicatedInvocationHandler(S object, HashMap<Method, Short> methodMap) {
            this.object = object;
            this.methodMap = methodMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Address> getRemoteMembersCopy() {
            List<Address> list = this.remoteMembers;
            synchronized (list) {
                return new ArrayList<Address>(this.remoteMembers);
            }
        }

        public void setDisp(ReplicatorRpcDispatcher<S> disp) {
            this.disp = disp;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Short methodNum = this.methodMap.get(method);
            if (methodNum == null || this.remoteMembers.isEmpty()) {
                Replicated annotation;
                if (methodNum != null && (annotation = method.getAnnotation(Replicated.class)) != null && annotation.remoteOnly()) {
                    return null;
                }
                try {
                    return method.invoke(this.object, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            try {
                Replicated annotation = method.getAnnotation(Replicated.class);
                if (annotation.replicateState() != Replicated.ReplicationMode.NONE) {
                    return this.handleReplicateState(method, args, annotation);
                }
                MethodCall call = new MethodCall(methodNum.shortValue(), args);
                List<Address> dests = null;
                if (annotation.remoteOnly() && (dests = this.getRemoteMembersCopy()).isEmpty()) {
                    return null;
                }
                RspList responses = this.disp.callRemoteMethods(dests, call, new RequestOptions().setMode(annotation.asynch() ? ResponseMode.GET_NONE : ResponseMode.GET_ALL).setTimeout(annotation.timeout()).setAnycasting(dests != null));
                if (annotation.asynch()) {
                    return null;
                }
                List results = responses.getResults();
                if (method.getReturnType() == Boolean.TYPE) {
                    for (Object o : results) {
                        if (Boolean.TRUE.equals(o)) continue;
                        return false;
                    }
                    return true;
                }
                if (method.getReturnType() == Collection.class) {
                    ArrayList result = new ArrayList();
                    for (Object o : results) {
                        result.addAll((Collection)o);
                    }
                    return results;
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(method + " " + args + " failed", e);
            }
        }

        protected Address whereIsState(Serializable stateId, long timeout) throws Exception {
            if (this.remoteMembers.isEmpty()) {
                return null;
            }
            RspList resp = this.disp.callRemoteMethods(this.getRemoteMembersCopy(), new MethodCall((short)(this.methodMap.size() - 5), new Object[]{stateId}), new RequestOptions(ResponseMode.GET_ALL, timeout));
            Collection values = resp.values();
            Rsp rsp = null;
            for (Rsp response : values) {
                if (!Boolean.TRUE.equals(response.getValue())) continue;
                rsp = response;
                break;
            }
            if (rsp == null) {
                return null;
            }
            return rsp.getSender();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object handleReplicateState(Method method, Object[] args, Replicated annotation) throws IllegalAccessException, Throwable, IOException, IllegalStateException, Exception {
            Object result = null;
            try {
                result = method.invoke(this.object, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            ReplicatedObject ro = (ReplicatedObject)this.object;
            Serializable stateId = (Serializable)args[0];
            if (annotation.replicateState() == Replicated.ReplicationMode.PUSH) {
                if (!this.remoteMembers.isEmpty()) {
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "replicating state", stateId});
                    JGroupsOutputStream oStream = new JGroupsOutputStream(this.disp, null, stateId, (short)(this.methodMap.size() - 3), true);
                    try {
                        ro.getState(stateId, (OutputStream)oStream);
                    }
                    finally {
                        oStream.close();
                    }
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "sent state", stateId});
                }
                return result;
            }
            if (result != null) {
                return result;
            }
            long timeout = annotation.timeout();
            return this.pullState(method, args, stateId, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object pullState(Method method, Object[] args, Serializable stateId, long timeout) throws Throwable {
            Object result = null;
            for (int i = 0; i < 3; ++i) {
                Promise p = null;
                boolean wait = true;
                Map<Serializable, Promise<Boolean>> map = this.loadingStates;
                synchronized (map) {
                    p = this.loadingStates.get(stateId);
                    if (p == null) {
                        wait = false;
                        if (method != null) {
                            try {
                                result = method.invoke(this.object, args);
                            }
                            catch (InvocationTargetException e) {
                                throw e.getCause();
                            }
                            if (result != null) {
                                return result;
                            }
                        }
                        p = new Promise();
                        this.loadingStates.put(stateId, (Promise<Boolean>)p);
                    }
                }
                if (wait) {
                    p.getResult(timeout);
                    continue;
                }
                try {
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "pulling state", stateId});
                    Address addr = this.whereIsState(stateId, timeout);
                    if (addr == null) {
                        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "timeout exceeded or first member"});
                        break;
                    }
                    JGroupsInputStream is = new JGroupsInputStream(15000L);
                    StreamingRunner runner = new StreamingRunner(this.object, stateId, is, p);
                    List<Serializable> key = Arrays.asList(stateId, new AddressWrapper(addr));
                    this.disp.inputStreams.put(key, is);
                    JGroupsObjectReplicator.this.executor.execute(runner);
                    this.disp.callRemoteMethod(addr, new MethodCall((short)(this.methodMap.size() - 4), new Object[]{stateId, new AddressWrapper(this.disp.getChannel().getAddress())}), new RequestOptions(ResponseMode.GET_NONE, 0L).setAnycasting(true));
                    Boolean fetched = (Boolean)p.getResult(timeout);
                    if (fetched != null) {
                        if (fetched.booleanValue()) {
                            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "pulled state", stateId});
                            if (method == null) break;
                            try {
                                result = method.invoke(this.object, args);
                            }
                            catch (InvocationTargetException e) {
                                throw e.getCause();
                            }
                            if (result == null) break;
                            Object object = result;
                            return object;
                        }
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50020, new Object[]{this.object, stateId}));
                        continue;
                    }
                    LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50022, new Object[]{this.object, stateId}));
                    continue;
                }
                finally {
                    Map<Serializable, Promise<Boolean>> e = this.loadingStates;
                    synchronized (e) {
                        this.loadingStates.remove(stateId);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View newView) {
            if (newView.getMembers() != null) {
                List<Address> list = this.remoteMembers;
                synchronized (list) {
                    this.remoteMembers.removeAll(newView.getMembers());
                    if (this.object instanceof ReplicatedObject && !this.remoteMembers.isEmpty()) {
                        HashSet<AddressWrapper> dropped = new HashSet<AddressWrapper>();
                        for (Address address : this.remoteMembers) {
                            dropped.add(new AddressWrapper(address));
                        }
                        ((ReplicatedObject)this.object).droppedMembers(dropped);
                    }
                    this.remoteMembers.clear();
                    this.remoteMembers.addAll(newView.getMembers());
                    this.remoteMembers.remove(this.disp.getChannel().getAddress());
                }
            }
        }
    }

    private static final class StreamingRunner
    implements Runnable {
        private final Object object;
        private final Serializable stateId;
        private final JGroupsInputStream is;
        private Promise<Boolean> promise;

        private StreamingRunner(Object object, Serializable stateId, JGroupsInputStream is, Promise<Boolean> promise) {
            this.object = object;
            this.stateId = stateId;
            this.is = is;
            this.promise = promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.stateId == null) {
                    ((ReplicatedObject)this.object).setState((InputStream)this.is);
                } else {
                    ((ReplicatedObject)this.object).setState(this.stateId, (InputStream)this.is);
                }
                if (this.promise != null) {
                    this.promise.setResult((Object)Boolean.TRUE);
                }
                LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{"state set", this.stateId});
            }
            catch (Exception e) {
                if (this.promise != null) {
                    this.promise.setResult((Object)Boolean.FALSE);
                }
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50042, new Object[]{this.stateId}));
            }
            finally {
                this.is.close();
            }
        }
    }

    private final class ReplicatorRpcDispatcher<S>
    extends RpcDispatcher {
        private final S object;
        private boolean initialized;
        private final HashMap<Method, Short> methodMap;
        private final ArrayList<Method> methodList;
        Map<List<?>, JGroupsInputStream> inputStreams;

        private ReplicatorRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object serverObj, S object, HashMap<Method, Short> methodMap, ArrayList<Method> methodList) {
            super(channel, l, l2, serverObj);
            this.inputStreams = new ConcurrentHashMap();
            this.object = object;
            this.methodMap = methodMap;
            this.methodList = methodList;
            this.setMarshaller(new ContextAwareMarshaller(((Object)((Object)this)).getClass().getClassLoader()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object handle(Message req) {
            Object body = null;
            if (req == null || req.getLength() == 0) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("message or message buffer is null");
                }
                return null;
            }
            try {
                body = this.req_marshaller != null ? this.req_marshaller.objectFromBuffer(req.getBuffer(), req.getOffset(), req.getLength()) : req.getObject();
            }
            catch (Throwable e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("exception marshalling object", e);
                }
                return e;
            }
            if (!(body instanceof MethodCall)) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("message does not contain a MethodCall object");
                }
                return new IllegalArgumentException("message does not contain a MethodCall object");
            }
            MethodCall method_call = (MethodCall)body;
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[sender=" + req.getSrc() + "], method_call: " + method_call);
                }
                if (method_call.getId() >= this.methodList.size() - 5 && req.getSrc().equals(this.local_addr)) {
                    return null;
                }
                if (method_call.getId() >= this.methodList.size() - 3) {
                    AddressWrapper address = new AddressWrapper(req.getSrc());
                    Serializable stateId = (Serializable)method_call.getArgs()[0];
                    List<Serializable> key = Arrays.asList(stateId, address);
                    JGroupsInputStream is = this.inputStreams.get(key);
                    if (method_call.getId() == this.methodList.size() - 3) {
                        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "create state", stateId});
                        if (is != null) {
                            is.receive(null);
                        }
                        is = new JGroupsInputStream(15000L);
                        this.inputStreams.put(key, is);
                        JGroupsObjectReplicator.this.executor.execute(new StreamingRunner(this.object, stateId, is, null));
                    } else if (method_call.getId() == this.methodList.size() - 2) {
                        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "building state", stateId});
                        if (is != null) {
                            is.receive((byte[])method_call.getArgs()[1]);
                        }
                    } else if (method_call.getId() == this.methodList.size() - 1) {
                        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "finished state", stateId});
                        if (is != null) {
                            is.receive(null);
                        }
                        this.inputStreams.remove(key);
                    }
                    return null;
                }
                if (method_call.getId() == this.methodList.size() - 5) {
                    ReplicatedObject ro = (ReplicatedObject)this.object;
                    Serializable stateId = (Serializable)method_call.getArgs()[0];
                    if (stateId == null) {
                        ReplicatorRpcDispatcher key = this;
                        synchronized (key) {
                            if (this.initialized) {
                                return Boolean.TRUE;
                            }
                            return null;
                        }
                    }
                    if (ro.hasState(stateId)) {
                        return Boolean.TRUE;
                    }
                    return null;
                }
                if (method_call.getId() == this.methodList.size() - 4) {
                    ReplicatedObject ro = (ReplicatedObject)this.object;
                    String stateId = (String)method_call.getArgs()[0];
                    AddressWrapper dest = (AddressWrapper)method_call.getArgs()[1];
                    JGroupsOutputStream oStream = new JGroupsOutputStream(this, Arrays.asList(dest.address), (Serializable)((Object)stateId), (short)(this.methodMap.size() - 3), false);
                    try {
                        if (stateId == null) {
                            ro.getState((OutputStream)oStream);
                        } else {
                            ro.getState((Serializable)((Object)stateId), (OutputStream)oStream);
                        }
                    }
                    finally {
                        oStream.close();
                    }
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "sent state", stateId});
                    return null;
                }
                Method m = this.method_lookup.findMethod(method_call.getId());
                if (m == null) {
                    throw new Exception("no method found for " + method_call.getId());
                }
                method_call.setMethod(m);
                return method_call.invoke(this.server_obj);
            }
            catch (Throwable x) {
                return x;
            }
        }
    }
}

