/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.oauth;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrant;
import org.teiid.OAuthCredential;

public class OAuth20CredentialImpl
implements OAuthCredential {
    private String clientId;
    private String clientSecret;
    private String refreshToken;
    private String accessTokenURI;
    private ClientAccessToken accessToken;

    public String getAuthorizationHeader(String resourceURI, String httpMethod) {
        if (this.accessToken == null || this.expired(this.accessToken)) {
            this.accessToken = this.getAccessToken();
        }
        return "Bearer " + this.accessToken.getTokenKey();
    }

    private boolean expired(ClientAccessToken token) {
        return token.getIssuedAt() + token.getExpiresIn() - System.currentTimeMillis() < 0L;
    }

    protected ClientAccessToken getAccessToken() {
        OAuthClientUtils.Consumer consumer = new OAuthClientUtils.Consumer(this.getClientId(), this.getClientSecret());
        WebClient client = WebClient.create((String)this.getAccessTokenURI());
        RefreshTokenGrant grant = new RefreshTokenGrant(this.getRefreshToken());
        return OAuthClientUtils.getAccessToken((WebClient)client, (OAuthClientUtils.Consumer)consumer, (AccessTokenGrant)grant, null, (boolean)false);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessTokenURI() {
        return this.accessTokenURI;
    }

    public void setAccessTokenURI(String accessTokenURI) {
        this.accessTokenURI = accessTokenURI;
    }
}

