/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.oauth;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.teiid.OAuthCredential;
import org.teiid.jboss.oauth.OAuth10CredentialImpl;

public class OAuth10LoginModule
extends AbstractPasswordCredentialLoginModule {
    private String consumerKey;
    private String consumerSecret;
    private String accessKey;
    private String accessSecret;
    protected OAuthCredential credential;
    protected Subject callerSubject;
    protected Principal callerPrincipal;

    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.consumerKey = (String)options.get("consumer-key");
        this.consumerSecret = (String)options.get("consumer-secret");
        this.accessKey = (String)options.get("access-key");
        this.accessSecret = (String)options.get("access-secret");
    }

    public boolean login() throws LoginException {
        this.callerSubject = OAuth10LoginModule.getSubject();
        this.callerPrincipal = OAuth10LoginModule.getPrincipal();
        if (this.getCredential() == null) {
            if (this.getConsumerKey() == null || this.getConsumerSecret() == null || this.getAccessKey() == null || this.getAccessSecret() == null) {
                this.loginOk = false;
                return false;
            }
            OAuth10CredentialImpl cred = new OAuth10CredentialImpl();
            cred.setConsumerKey(this.getConsumerKey());
            cred.setConsumerSecret(this.getConsumerSecret());
            cred.setAccessToken(this.getAccessKey());
            cred.setAccessSecret(this.getAccessSecret());
            this.setCredential(cred);
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        if (this.callerPrincipal != null) {
            return this.callerPrincipal;
        }
        return new SimplePrincipal("oauth-user");
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(this.getIdentity());
        OAuth10LoginModule.addPrivateCredential(this.subject, this.getCredential());
        return true;
    }

    static void addPrivateCredential(final Subject subject, final Object obj) {
        if (System.getSecurityManager() == null) {
            subject.getPrivateCredentials().add(obj);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().add(obj);
                    return null;
                }
            });
        }
    }

    static Principal getPrincipal() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getPrincipal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                return SecurityContextAssociation.getPrincipal();
            }
        });
    }

    static Subject getSubject() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getSubject();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return SecurityContextAssociation.getSubject();
            }
        });
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public OAuthCredential getCredential() {
        return this.credential;
    }

    public void setCredential(OAuthCredential credential) {
        this.credential = credential;
    }
}

