/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.oauth;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.teiid.OAuthCredential;
import org.teiid.jboss.oauth.OAuth20CredentialImpl;

public class OAuth20LoginModule
extends AbstractPasswordCredentialLoginModule {
    private String clientId;
    private String clientSecret;
    private String refreshToken;
    private String accessTokenURI;
    protected OAuthCredential credential;
    protected Subject callerSubject;
    protected Principal callerPrincipal;

    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.clientId = (String)options.get("client-id");
        this.clientSecret = (String)options.get("client-secret");
        this.refreshToken = (String)options.get("refresh-token");
        this.accessTokenURI = (String)options.get("access-token-uri");
    }

    public boolean login() throws LoginException {
        this.callerSubject = OAuth20LoginModule.getSubject();
        this.callerPrincipal = OAuth20LoginModule.getPrincipal();
        if (this.getCredential() == null) {
            if (this.getClientId() == null || this.getClientSecret() == null || this.getAccessTokenURI() == null || this.getRefreshToken() == null) {
                this.loginOk = false;
                return false;
            }
            OAuth20CredentialImpl cred = new OAuth20CredentialImpl();
            cred.setClientId(this.getClientId());
            cred.setClientSecret(this.getClientSecret());
            cred.setRefreshToken(this.getRefreshToken());
            cred.setAccessTokenURI(this.getAccessTokenURI());
            this.setCredential(cred);
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        if (this.callerPrincipal != null) {
            return this.callerPrincipal;
        }
        return new SimplePrincipal("oauth-user");
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(this.getIdentity());
        OAuth20LoginModule.addPrivateCredential(this.subject, this.getCredential());
        return true;
    }

    static void addPrivateCredential(final Subject subject, final Object obj) {
        if (System.getSecurityManager() == null) {
            subject.getPrivateCredentials().add(obj);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().add(obj);
                    return null;
                }
            });
        }
    }

    static Principal getPrincipal() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getPrincipal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                return SecurityContextAssociation.getPrincipal();
            }
        });
    }

    static Subject getSubject() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getSubject();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return SecurityContextAssociation.getSubject();
            }
        });
    }

    public OAuthCredential getCredential() {
        return this.credential;
    }

    public void setCredential(OAuthCredential credential) {
        this.credential = credential;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessTokenURI() {
        return this.accessTokenURI;
    }

    public void setAccessTokenURI(String accessTokenURI) {
        this.accessTokenURI = accessTokenURI;
    }
}

