/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;

public class RestASMBasedWebArchiveBuilder {
    public byte[] createRestArchive(VDBMetaData vdb) throws FileNotFoundException, IOException {
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        Properties props = new Properties();
        props.setProperty("${context-name}", vdb.getName() + "_" + vdb.getVersion());
        props.setProperty("${vdb-name}", vdb.getName());
        props.setProperty("${vdb-version}", String.valueOf(vdb.getVersion()));
        boolean passthroughAuth = false;
        String securityType = vdb.getPropertyValue("{http://teiid.org/rest}security-type");
        String securityDomain = vdb.getPropertyValue("{http://teiid.org/rest}security-domain");
        String securityRole = vdb.getPropertyValue("{http://teiid.org/rest}security-role");
        String passthoughAuthStr = vdb.getPropertyValue("{http://teiid.org/rest}passthrough-auth");
        if (passthoughAuthStr != null) {
            passthroughAuth = Boolean.parseBoolean(passthoughAuthStr);
        }
        props.setProperty("${security-role}", securityRole == null ? "rest" : securityRole);
        props.setProperty("${security-domain}", securityDomain == null ? "teiid-security" : securityDomain);
        if (securityType == null) {
            securityType = "httpbasic";
        }
        if (securityType.equalsIgnoreCase("none")) {
            props.setProperty("${security-content}", "");
        } else if (securityType.equalsIgnoreCase("httpbasic")) {
            props.setProperty("${security-content}", this.replaceTemplates(this.getFileContents("rest-war/httpbasic.xml"), props));
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(byteStream);
        this.writeEntry("WEB-INF/web.xml", out, this.replaceTemplates(this.getFileContents("rest-war/web.xml"), props).getBytes());
        this.writeEntry("WEB-INF/jboss-web.xml", out, this.replaceTemplates(this.getFileContents("rest-war/jboss-web.xml"), props).getBytes());
        ArrayList<String> applicationViews = new ArrayList<String>();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            Schema schema = metadataStore.getSchema(model.getName());
            byte[] viewContents = this.getViewClass(vdb.getName(), vdb.getVersion(), model.getName(), schema, passthroughAuth);
            if (viewContents == null) continue;
            this.writeEntry("WEB-INF/classes/org/teiid/jboss/rest/" + model.getName() + ".class", out, viewContents);
            applicationViews.add(schema.getName());
        }
        this.writeEntry("WEB-INF/classes/org/teiid/jboss/rest/TeiidRestApplication.class", out, this.getApplicationClass(applicationViews));
        this.writeEntry("META-INF/MANIFEST.MF", out, this.getFileContents("rest-war/MANIFEST.MF").getBytes());
        out.close();
        return byteStream.toByteArray();
    }

    private void writeEntry(String name, ZipOutputStream out, byte[] contents) throws IOException {
        ZipEntry e = new ZipEntry(name);
        out.putNextEntry(e);
        FileUtils.write((InputStream)new ByteArrayInputStream(contents), (OutputStream)out, (int)1024);
        out.closeEntry();
    }

    private String getFileContents(String file) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(file);
        InputStreamReader reader = new InputStreamReader(in);
        String webXML = ObjectConverterUtil.convertToString((Reader)reader);
        return webXML;
    }

    private String replaceTemplates(String orig, Properties replacements) {
        for (String key : replacements.stringPropertyNames()) {
            orig = StringUtil.replace((String)orig, (String)key, (String)replacements.getProperty(key));
        }
        return orig;
    }

    private static HashSet<String> getPathParameters(String uri) {
        HashSet<String> pathParams = new HashSet<String>();
        if (uri.contains("{")) {
            while (uri.indexOf("}") > -1) {
                int start = uri.indexOf("{");
                int end = uri.indexOf("}");
                String param = uri.substring(start + 1, end);
                uri = uri.substring(end + 1);
                pathParams.add(param);
            }
        }
        return pathParams;
    }

    public byte[] getApplicationClass(ArrayList<String> models) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, "org/teiid/jboss/rest/TeiidRestApplication", null, "javax/ws/rs/core/Application", null);
        FieldVisitor fv = cw.visitField(2, "singletons", "Ljava/util/Set;", "Ljava/util/Set<Ljava/lang/Object;>;", null);
        fv.visitEnd();
        fv = cw.visitField(2, "empty", "Ljava/util/Set;", "Ljava/util/Set<Ljava/lang/Class<*>;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "javax/ws/rs/core/Application", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/HashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
        mv.visitFieldInsn(181, "org/teiid/jboss/rest/TeiidRestApplication", "singletons", "Ljava/util/Set;");
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/HashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
        mv.visitFieldInsn(181, "org/teiid/jboss/rest/TeiidRestApplication", "empty", "Ljava/util/Set;");
        mv.visitVarInsn(25, 0);
        for (int i = 0; i < models.size(); ++i) {
            mv.visitFieldInsn(180, "org/teiid/jboss/rest/TeiidRestApplication", "singletons", "Ljava/util/Set;");
            mv.visitTypeInsn(187, "org/teiid/jboss/rest/" + models.get(i));
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "org/teiid/jboss/rest/" + models.get(i), "<init>", "()V");
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
            if (i >= models.size() - 1) continue;
            mv.visitVarInsn(25, 0);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getClasses", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/lang/Class<*>;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/teiid/jboss/rest/TeiidRestApplication", "empty", "Ljava/util/Set;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getSingletons", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/teiid/jboss/rest/TeiidRestApplication", "singletons", "Ljava/util/Set;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] getViewClass(String vdbName, int vdbVersion, String modelName, Schema schema, boolean passthroughAuth) {
        ClassWriter cw = new ClassWriter(1);
        boolean hasValidProcedures = false;
        cw.visit(50, 33, "org/teiid/jboss/rest/" + modelName, null, "org/teiid/jboss/rest/TeiidRSProvider", null);
        AnnotationVisitor av0 = cw.visitAnnotation("Ljavax/ws/rs/Path;", true);
        av0.visit("value", (Object)("/" + modelName.toLowerCase()));
        av0.visitEnd();
        cw.visitInnerClass("javax/ws/rs/core/Response$Status", "javax/ws/rs/core/Response", "Status", 16409);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/teiid/jboss/rest/TeiidRSProvider", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        Collection procedures = schema.getProcedures().values();
        for (Procedure procedure : procedures) {
            String uri = procedure.getProperty("{http://teiid.org/rest}URI", false);
            String method = procedure.getProperty("{http://teiid.org/rest}METHOD", false);
            String contentType = procedure.getProperty("{http://teiid.org/rest}PRODUCES", false);
            String charSet = procedure.getProperty("{http://teiid.org/rest}CHARSET", false);
            if (uri == null || method == null) continue;
            if (contentType == null) {
                contentType = this.findContentType(procedure);
            }
            if (contentType == null) continue;
            if ((contentType = contentType.toLowerCase()).equals("xml")) {
                contentType = "application/xml";
            } else if (contentType.equals("json")) {
                contentType = "application/json";
            } else if (contentType.equals("plain")) {
                contentType = "text/plain";
            }
            this.buildRestService(vdbName, vdbVersion, modelName, procedure, method, uri, cw, contentType, charSet, passthroughAuth);
            hasValidProcedures = true;
        }
        this.buildQueryProcedure(vdbName, vdbVersion, modelName, "xml", cw, passthroughAuth);
        this.buildQueryProcedure(vdbName, vdbVersion, modelName, "json", cw, passthroughAuth);
        cw.visitEnd();
        if (!hasValidProcedures) {
            return null;
        }
        return cw.toByteArray();
    }

    private String findContentType(Procedure procedure) {
        String contentType;
        block4: {
            block2: {
                Column returnColumn;
                block3: {
                    contentType = "plain";
                    ColumnSet rs = procedure.getResultSet();
                    if (rs == null) break block2;
                    returnColumn = (Column)rs.getColumns().get(0);
                    if (!returnColumn.getDatatype().getRuntimeTypeName().equals("xml")) break block3;
                    contentType = "xml";
                    break block4;
                }
                if (!returnColumn.getDatatype().getRuntimeTypeName().equals("clob")) break block4;
                contentType = "json";
                break block4;
            }
            for (ProcedureParameter pp : procedure.getParameters()) {
                if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
                if (pp.getDatatype().getRuntimeTypeName().equals("xml")) {
                    contentType = "xml";
                    continue;
                }
                if (!pp.getDatatype().getRuntimeTypeName().equals("clob")) continue;
                contentType = "json";
            }
        }
        return contentType;
    }

    private void buildRestService(String vdbName, int vdbVersion, String modelName, Procedure procedure, String method, String uri, ClassWriter cw, String contentType, String charSet, boolean passthroughAuth) {
        ArrayList<ProcedureParameter> params = new ArrayList<ProcedureParameter>(procedure.getParameters().size());
        boolean usingReturn = false;
        boolean hasLobInput = false;
        for (ProcedureParameter p : procedure.getParameters()) {
            if (p.getType() == ProcedureParameter.Type.In || p.getType() == ProcedureParameter.Type.InOut) {
                params.add(p);
            } else if (p.getType() == ProcedureParameter.Type.ReturnValue && procedure.getResultSet() == null) {
                usingReturn = true;
            }
            if (hasLobInput) continue;
            String runtimeType = p.getRuntimeType();
            hasLobInput = DataTypeManager.isLOB((String)runtimeType);
        }
        int paramsSize = params.size();
        boolean useMultipart = false;
        if (method.toUpperCase().equals("POST") && hasLobInput) {
            useMultipart = true;
        }
        StringBuilder paramSignature = new StringBuilder();
        paramSignature.append("(");
        for (int i = 0; i < paramsSize; ++i) {
            paramSignature.append("Ljava/lang/String;");
        }
        paramSignature.append(")");
        MethodVisitor mv = useMultipart ? cw.visitMethod(1, procedure.getName() + contentType.replace('/', '_'), "(Lorg/jboss/resteasy/plugins/providers/multipart/MultipartFormDataInput;)Ljava/io/InputStream;", null, new String[]{"javax/ws/rs/WebApplicationException"}) : cw.visitMethod(1, procedure.getName() + contentType.replace('/', '_'), paramSignature + "Ljava/io/InputStream;", null, new String[]{"javax/ws/rs/WebApplicationException"});
        AnnotationVisitor av0 = mv.visitAnnotation("Ljavax/ws/rs/Produces;", true);
        AnnotationVisitor av1 = av0.visitArray("value");
        av1.visit(null, (Object)contentType);
        av1.visitEnd();
        av0.visitEnd();
        av0 = mv.visitAnnotation("Ljavax/ws/rs/" + method.toUpperCase() + ";", true);
        av0.visitEnd();
        av0 = mv.visitAnnotation("Ljavax/ws/rs/Path;", true);
        av0.visit("value", (Object)uri);
        av0.visitEnd();
        av0 = mv.visitAnnotation("Ljavax/annotation/security/PermitAll;", true);
        av0.visitEnd();
        if (useMultipart) {
            av0 = mv.visitAnnotation("Ljavax/ws/rs/Consumes;", true);
            av1 = av0.visitArray("value");
            av1.visit(null, (Object)"multipart/form-data");
            av1.visitEnd();
            av0.visitEnd();
        }
        if (!useMultipart) {
            HashSet<String> pathParms = RestASMBasedWebArchiveBuilder.getPathParameters(uri);
            for (int i = 0; i < paramsSize; ++i) {
                String paramType = "Ljavax/ws/rs/FormParam;";
                if (method.toUpperCase().equals("GET")) {
                    paramType = "Ljavax/ws/rs/QueryParam;";
                }
                if (pathParms.contains(((ProcedureParameter)params.get(i)).getName())) {
                    paramType = "Ljavax/ws/rs/PathParam;";
                }
                av0 = mv.visitParameterAnnotation(i, paramType, true);
                av0.visit("value", (Object)((ProcedureParameter)params.get(i)).getName());
                av0.visitEnd();
            }
        }
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/sql/SQLException");
        mv.visitLabel(l0);
        if (!useMultipart) {
            mv.visitTypeInsn(187, "java/util/LinkedHashMap");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V");
            mv.visitVarInsn(58, paramsSize + 1);
            for (int i = 0; i < paramsSize; ++i) {
                mv.visitVarInsn(25, paramsSize + 1);
                mv.visitLdcInsn((Object)((ProcedureParameter)params.get(i)).getName());
                mv.visitVarInsn(25, i + 1);
                mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
            }
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)vdbName);
            mv.visitIntInsn(16, vdbVersion);
            mv.visitLdcInsn((Object)procedure.getSQLString());
            mv.visitVarInsn(25, paramsSize + 1);
            mv.visitLdcInsn((Object)(charSet == null ? "" : charSet));
            mv.visitInsn(passthroughAuth ? 4 : 3);
            mv.visitInsn(usingReturn ? 4 : 3);
            mv.visitMethodInsn(182, "org/teiid/jboss/rest/" + modelName, "execute", "(Ljava/lang/String;ILjava/lang/String;Ljava/util/LinkedHashMap;Ljava/lang/String;ZZ)Ljava/io/InputStream;");
            mv.visitLabel(l1);
            mv.visitInsn(176);
            mv.visitLabel(l2);
            mv.visitFrame(4, 0, null, 1, new Object[]{"java/sql/SQLException"});
            mv.visitVarInsn(58, paramsSize + 1);
            mv.visitTypeInsn(187, "javax/ws/rs/WebApplicationException");
            mv.visitInsn(89);
            mv.visitVarInsn(25, paramsSize + 1);
            mv.visitFieldInsn(178, "javax/ws/rs/core/Response$Status", "INTERNAL_SERVER_ERROR", "Ljavax/ws/rs/core/Response$Status;");
            mv.visitMethodInsn(183, "javax/ws/rs/WebApplicationException", "<init>", "(Ljava/lang/Throwable;Ljavax/ws/rs/core/Response$Status;)V");
            mv.visitInsn(191);
            mv.visitMaxs(7, paramsSize + 2);
            mv.visitEnd();
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)vdbName);
            mv.visitIntInsn(16, vdbVersion);
            mv.visitLdcInsn((Object)procedure.getSQLString());
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)(charSet == null ? "" : charSet));
            mv.visitInsn(passthroughAuth ? 4 : 3);
            mv.visitInsn(usingReturn ? 4 : 3);
            mv.visitMethodInsn(182, "org/teiid/jboss/rest/" + modelName, "executePost", "(Ljava/lang/String;ILjava/lang/String;Lorg/jboss/resteasy/plugins/providers/multipart/MultipartFormDataInput;Ljava/lang/String;ZZ)Ljava/io/InputStream;");
            mv.visitLabel(l1);
            mv.visitInsn(176);
            mv.visitLabel(l2);
            mv.visitFrame(4, 0, null, 1, new Object[]{"java/sql/SQLException"});
            mv.visitVarInsn(58, 2);
            mv.visitTypeInsn(187, "javax/ws/rs/WebApplicationException");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(178, "javax/ws/rs/core/Response$Status", "INTERNAL_SERVER_ERROR", "Ljavax/ws/rs/core/Response$Status;");
            mv.visitMethodInsn(183, "javax/ws/rs/WebApplicationException", "<init>", "(Ljava/lang/Throwable;Ljavax/ws/rs/core/Response$Status;)V");
            mv.visitInsn(191);
            mv.visitMaxs(8, 3);
            mv.visitEnd();
        }
    }

    private void buildQueryProcedure(String vdbName, int vdbVersion, String modelName, String context, ClassWriter cw, boolean passthroughAuth) {
        MethodVisitor mv = cw.visitMethod(1, "sqlQuery" + context, "(Ljava/lang/String;)Ljava/io/InputStream;", null, null);
        AnnotationVisitor av0 = mv.visitAnnotation("Ljavax/ws/rs/Produces;", true);
        AnnotationVisitor av1 = av0.visitArray("value");
        av1.visit(null, (Object)("application/" + context));
        av1.visitEnd();
        av0.visitEnd();
        av0 = mv.visitAnnotation("Ljavax/ws/rs/POST;", true);
        av0.visitEnd();
        av0 = mv.visitAnnotation("Ljavax/ws/rs/Path;", true);
        av0.visit("value", (Object)"/query");
        av0.visitEnd();
        av0 = mv.visitParameterAnnotation(0, "Ljavax/ws/rs/FormParam;", true);
        av0.visit("value", (Object)"sql");
        av0.visitEnd();
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/sql/SQLException");
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)vdbName);
        mv.visitIntInsn(16, vdbVersion);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(context.equals("xml") ? 3 : 4);
        mv.visitInsn(passthroughAuth ? 4 : 3);
        mv.visitMethodInsn(182, "org/teiid/jboss/rest/" + modelName, "executeQuery", "(Ljava/lang/String;ILjava/lang/String;ZZ)Ljava/io/InputStream;");
        mv.visitLabel(l1);
        mv.visitInsn(176);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/sql/SQLException"});
        mv.visitVarInsn(58, 2);
        mv.visitTypeInsn(187, "javax/ws/rs/WebApplicationException");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(178, "javax/ws/rs/core/Response$Status", "INTERNAL_SERVER_ERROR", "Ljavax/ws/rs/core/Response$Status;");
        mv.visitMethodInsn(183, "javax/ws/rs/WebApplicationException", "<init>", "(Ljava/lang/Throwable;Ljavax/ws/rs/core/Response$Status;)V");
        mv.visitInsn(191);
        mv.visitMaxs(6, 3);
        mv.visitEnd();
    }
}

