/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.msc.service.ServiceName;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.jboss.IntegrationPlugin;

public class TeiidServiceNames {
    public static ServiceName ENGINE = ServiceName.JBOSS.append(new String[]{"teiid", "query-engine"});
    public static ServiceName TRANSLATOR_REPO = ServiceName.JBOSS.append(new String[]{"teiid", "translator-repository"});
    public static ServiceName VDB_REPO = ServiceName.JBOSS.append(new String[]{"teiid", "vdb-repository"});
    public static ServiceName TRANSLATOR_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "translator"});
    public static ServiceName TRANSPORT_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "transport"});
    private static ServiceName EMBEDDED_TRANSPORT_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "embedded", "transport"});
    public static ServiceName BUFFER_DIR = ServiceName.JBOSS.append(new String[]{"teiid", "buffer.dir"});
    public static ServiceName DATA_DIR = ServiceName.JBOSS.append(new String[]{"teiid", "data.dir"});
    public static ServiceName BUFFER_MGR = ServiceName.JBOSS.append(new String[]{"teiid", "buffer-mgr"});
    public static ServiceName TUPLE_BUFFER = ServiceName.JBOSS.append(new String[]{"teiid", "tuple_buffer"});
    public static ServiceName AUTHORIZATION_VALIDATOR = ServiceName.JBOSS.append(new String[]{"teiid", "authorization-validator"});
    public static ServiceName PREPARSER = ServiceName.JBOSS.append(new String[]{"teiid", "preparser"});
    private static ServiceName VDB_SVC_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "vdb"});
    private static ServiceName VDB_FINISHED_SVC_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "vdb-finished"});
    private static ServiceName VDB_SWITCH_SVC_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "switch"});
    public static ServiceName OBJECT_SERIALIZER = ServiceName.JBOSS.append(new String[]{"teiid", "object-serializer"});
    public static ServiceName CACHE_RESULTSET = ServiceName.JBOSS.append(new String[]{"teiid", "cache", "resultset"});
    public static ServiceName CACHE_PREPAREDPLAN = ServiceName.JBOSS.append(new String[]{"teiid", "cache", "prepared-plan"});
    public static ServiceName OBJECT_REPLICATOR = ServiceName.JBOSS.append(new String[]{"teiid", "object-replicator"});
    public static ServiceName VDB_STATUS_CHECKER = ServiceName.JBOSS.append(new String[]{"teiid", "vdb-status-checker"});
    public static ServiceName DS_LISTENER_BASE = ServiceName.JBOSS.append(new String[]{"teiid", "ds-listener"});
    public static ServiceName EVENT_DISTRIBUTOR_FACTORY = ServiceName.JBOSS.append(new String[]{"teiid", "event-distributor-factory"});
    public static ServiceName RESULTSET_CACHE_FACTORY = ServiceName.JBOSS.append(new String[]{"teiid", "infinispan-rs-cache-factory"});
    public static ServiceName PREPAREDPLAN_CACHE_FACTORY = ServiceName.JBOSS.append(new String[]{"teiid", "infinispan-pp-cache-factory"});
    public static ServiceName MATVIEW_SERVICE = ServiceName.JBOSS.append(new String[]{"teiid", "matview-service"});

    public static ServiceName translatorServiceName(String name) {
        return ServiceName.of((ServiceName)TRANSLATOR_BASE, (String[])new String[]{name});
    }

    public static ServiceName vdbServiceName(String vdbName, int version) {
        return VDB_SVC_BASE.append(new String[]{vdbName, String.valueOf(version)});
    }

    public static ServiceName vdbFinishedServiceName(String vdbName, int version) {
        return VDB_FINISHED_SVC_BASE.append(new String[]{vdbName, String.valueOf(version)});
    }

    public static ServiceName vdbSwitchServiceName(String vdbName, int version) {
        return VDB_SWITCH_SVC_BASE.append(new String[]{vdbName, String.valueOf(version)});
    }

    public static ServiceName executorServiceName(String poolName) {
        return ServiceName.JBOSS.append(new String[]{"thread", "executor", poolName});
    }

    public static ServiceName transportServiceName(String name) {
        return ServiceName.of((ServiceName)TRANSPORT_BASE, (String[])new String[]{name});
    }

    public static ServiceName embeddedTransportServiceName(String name) {
        return EMBEDDED_TRANSPORT_BASE.append(new String[]{name});
    }

    public static ServiceName dsListenerServiceName(String vdbName, int version, String name) throws InvalidServiceNameException {
        try {
            return ServiceName.of((ServiceName)DS_LISTENER_BASE, (String[])new String[]{vdbName, String.valueOf(version), VDBStatusChecker.stripContext((String)name)});
        }
        catch (RuntimeException e) {
            throw new InvalidServiceNameException(IntegrationPlugin.Event.TEIID50099, e, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50099, new Object[]{name, vdbName, version}));
        }
    }

    public static class InvalidServiceNameException
    extends TeiidException {
        private static final long serialVersionUID = 7555741825606486101L;

        public InvalidServiceNameException(BundleUtil.Event code, Throwable t, String message) {
            super(code, t, message);
        }
    }
}

