/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.teiid.jboss.Element;
import org.teiid.jboss.Namespace;
import org.teiid.jboss.TeiidConstants;

class TeiidSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static TeiidSubsystemParser INSTANCE = new TeiidSubsystemParser();

    TeiidSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ArrayList translators;
        ArrayList transports;
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (!node.isDefined()) {
            return;
        }
        TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.ASYNC_THREAD_POOL_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        if (this.like(node, Element.BUFFER_SERVICE_ELEMENT)) {
            writer.writeStartElement(Element.BUFFER_SERVICE_ELEMENT.getLocalName());
            this.writeBufferService(writer, node);
            writer.writeEndElement();
        }
        TeiidConstants.MAX_THREADS_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_SOURCE_ROWS_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.QUERY_TIMEOUT.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.WORKMANAGER.marshallAsElement(node, false, (XMLStreamWriter)writer);
        TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT.marshallAsElement(node, (XMLStreamWriter)writer);
        TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT.marshallAsElement(node, (XMLStreamWriter)writer);
        TeiidConstants.PREPARSER_MODULE_ELEMENT.marshallAsElement(node, (XMLStreamWriter)writer);
        if (this.like(node, Element.RESULTSET_CACHE_ELEMENT)) {
            writer.writeStartElement(Element.RESULTSET_CACHE_ELEMENT.getLocalName());
            this.writeResultsetCacheConfiguration(writer, node);
            writer.writeEndElement();
        }
        if (this.like(node, Element.PREPAREDPLAN_CACHE_ELEMENT)) {
            writer.writeStartElement(Element.PREPAREDPLAN_CACHE_ELEMENT.getLocalName());
            this.writePreparedPlanCacheConfiguration(writer, node);
            writer.writeEndElement();
        }
        if (this.like(node, Element.DISTRIBUTED_CACHE)) {
            writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
            this.writeObjectReplicatorConfiguration(writer, node);
            writer.writeEndElement();
        }
        if (this.has(node, Element.TRANSPORT_ELEMENT.getLocalName()) && !(transports = new ArrayList(node.get(Element.TRANSPORT_ELEMENT.getLocalName()).keys())).isEmpty()) {
            for (String transport : transports) {
                writer.writeStartElement(Element.TRANSPORT_ELEMENT.getLocalName());
                this.writeTransportConfiguration(writer, node.get(new String[]{Element.TRANSPORT_ELEMENT.getLocalName(), transport}), transport);
                writer.writeEndElement();
            }
        }
        if (this.has(node, Element.TRANSLATOR_ELEMENT.getLocalName()) && !(translators = new ArrayList(node.get(Element.TRANSLATOR_ELEMENT.getLocalName()).keys())).isEmpty()) {
            for (String translator : translators) {
                writer.writeStartElement(Element.TRANSLATOR_ELEMENT.getLocalName());
                this.writeTranslator(writer, node.get(new String[]{Element.TRANSLATOR_ELEMENT.getLocalName(), translator}), translator);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeObjectReplicatorConfiguration(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        TeiidConstants.DC_STACK_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
    }

    private void writeTranslator(XMLExtendedStreamWriter writer, ModelNode node, String translatorName) throws XMLStreamException {
        writer.writeAttribute(Element.TRANSLATOR_NAME_ATTRIBUTE.getLocalName(), translatorName);
        TeiidConstants.TRANSLATOR_MODULE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
    }

    private void writeTransportConfiguration(XMLExtendedStreamWriter writer, ModelNode node, String transportName) throws XMLStreamException {
        writer.writeAttribute(Element.TRANSPORT_NAME_ATTRIBUTE.getLocalName(), transportName);
        TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE.marshallAsAttribute(node, true, (XMLStreamWriter)writer);
        TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        if (this.like(node, Element.AUTHENTICATION_ELEMENT)) {
            writer.writeStartElement(Element.AUTHENTICATION_ELEMENT.getLocalName());
            TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (this.like(node, Element.PG_ELEMENT)) {
            writer.writeStartElement(Element.PG_ELEMENT.getLocalName());
            TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (this.like(node, Element.SSL_ELEMENT)) {
            writer.writeStartElement(Element.SSL_ELEMENT.getLocalName());
            TeiidConstants.SSL_MODE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            if (this.like(node, Element.SSL_KETSTORE_ELEMENT)) {
                writer.writeStartElement(Element.SSL_KETSTORE_ELEMENT.getLocalName());
                TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            if (this.like(node, Element.SSL_TRUSTSTORE_ELEMENT)) {
                writer.writeStartElement(Element.SSL_TRUSTSTORE_ELEMENT.getLocalName());
                TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeBufferService(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        TeiidConstants.USE_DISK_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.INLINE_LOBS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.ENCRYPT_FILES_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
    }

    private void writeResultsetCacheConfiguration(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        TeiidConstants.RSC_NAME_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.RSC_ENABLE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
    }

    private void writePreparedPlanCacheConfiguration(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        TeiidConstants.PPC_NAME_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        TeiidConstants.PPC_ENABLE_ATTRIBUTE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private boolean like(ModelNode node, Element element) {
        if (node.isDefined()) {
            Set keys = node.keys();
            for (String key : keys) {
                if (!key.startsWith(element.getLocalName()) || !node.get(key).isDefined()) continue;
                return true;
            }
        }
        return false;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "teiid");
        address.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(address);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case TEIID_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALLOW_ENV_FUNCTION_ELEMENT: 
                        case EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT: 
                        case DETECTING_CHANGE_EVENTS_ELEMENT: {
                            bootServices.get(reader.getLocalName()).set(Boolean.parseBoolean(reader.getElementText()));
                            continue block16;
                        }
                        case POLICY_DECIDER_MODULE_ELEMENT: 
                        case AUTHORIZATION_VALIDATOR_MODULE_ELEMENT: 
                        case PREPARSER_MODULE_ELEMENT: 
                        case WORKMANAGER: {
                            bootServices.get(reader.getLocalName()).set(reader.getElementText());
                            continue block16;
                        }
                        case TIME_SLICE_IN_MILL_ELEMENT: {
                            bootServices.get(Element.TIME_SLICE_IN_MILLI_ELEMENT.getLocalName()).set(Integer.parseInt(reader.getElementText()));
                            continue block16;
                        }
                        case MAX_THREADS_ELEMENT: 
                        case MAX_ACTIVE_PLANS_ELEMENT: 
                        case USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT: 
                        case TIME_SLICE_IN_MILLI_ELEMENT: 
                        case MAX_ROWS_FETCH_SIZE_ELEMENT: 
                        case LOB_CHUNK_SIZE_IN_KB_ELEMENT: 
                        case QUERY_THRESHOLD_IN_SECS_ELEMENT: 
                        case MAX_SOURCE_ROWS_ELEMENT: 
                        case QUERY_TIMEOUT: {
                            bootServices.get(reader.getLocalName()).set(Integer.parseInt(reader.getElementText()));
                            continue block16;
                        }
                        case ASYNC_THREAD_POOL_ELEMENT: {
                            bootServices.get(reader.getLocalName()).set(reader.getElementText());
                            continue block16;
                        }
                        case DISTRIBUTED_CACHE: {
                            this.parseObjectReplicator(reader, bootServices);
                            continue block16;
                        }
                        case BUFFER_SERVICE_ELEMENT: {
                            this.parseBufferService(reader, bootServices);
                            continue block16;
                        }
                        case PREPAREDPLAN_CACHE_ELEMENT: {
                            this.parsePreparedPlanCacheConfiguration(reader, bootServices);
                            continue block16;
                        }
                        case RESULTSET_CACHE_ELEMENT: {
                            this.parseResultsetCacheConfiguration(reader, bootServices);
                            continue block16;
                        }
                        case TRANSPORT_ELEMENT: {
                            ModelNode transport = new ModelNode();
                            String name = this.parseTransport(reader, transport);
                            if (name != null) {
                                ModelNode transportAddress = address.clone();
                                transportAddress.add("transport", name);
                                transportAddress.protect();
                                transport.get("operation").set("add");
                                transport.get("address").set(transportAddress);
                                list.add(transport);
                                continue block16;
                            }
                            throw new XMLStreamException();
                        }
                        case TRANSLATOR_ELEMENT: {
                            ModelNode translatorNode = new ModelNode();
                            String translatorName = this.parseTranslator(reader, translatorNode);
                            if (translatorName != null) {
                                ModelNode translatorAddress = address.clone();
                                translatorAddress.add("translator", translatorName);
                                translatorAddress.protect();
                                translatorNode.get("operation").set("add");
                                translatorNode.get("address").set(translatorAddress);
                                list.add(translatorNode);
                                continue block16;
                            }
                            throw new XMLStreamException();
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseObjectReplicator(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.DISTRIBUTED_CACHE);
                switch (element) {
                    case DC_STACK_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private String parseTransport(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String transportName = null;
        if (reader.getAttributeCount() > 0) {
            block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName);
                switch (element) {
                    case TRANSPORT_NAME_ATTRIBUTE: 
                    case TRANSLATOR_NAME_ATTRIBUTE: {
                        transportName = attrValue;
                        continue block13;
                    }
                    case TRANSPORT_SOCKET_BINDING_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block13;
                    }
                    case TRANSPORT_PROTOCOL_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block13;
                    }
                    case TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block13;
                    }
                    case TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block13;
                    }
                    case TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION_ELEMENT: {
                    this.parseAuthentication(reader, node);
                    continue block14;
                }
                case PG_ELEMENT: {
                    this.parsePg(reader, node);
                    continue block14;
                }
                case SSL_ELEMENT: {
                    this.parseSSL(reader, node);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return transportName;
    }

    private ModelNode parseAuthentication(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.AUTHENTICATION_ELEMENT);
                switch (element) {
                    case AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    case AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    case AUTHENTICATION_TYPE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    case AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block7;
                    }
                    case AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parsePg(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.PG_ELEMENT);
                switch (element) {
                    case PG_MAX_LOB_SIZE_ALLOWED_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseSSL(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SSL_ELEMENT);
                switch (element) {
                    case SSL_MODE_ATTRIBUTE: 
                    case SSL_AUTH_MODE_ATTRIBUTE: 
                    case SSL_SSL_PROTOCOL_ATTRIBUTE: 
                    case SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE: 
                    case SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE: 
                    case SSL_KETSTORE_ALIAS_ATTRIBUTE: 
                    case SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SSL_KETSTORE_ELEMENT: {
                    this.parseKeystore(reader, node);
                    continue block8;
                }
                case SSL_TRUSTSTORE_ELEMENT: {
                    this.parseTruststore(reader, node);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return node;
    }

    private ModelNode parseKeystore(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SSL_KETSTORE_ELEMENT);
                switch (element) {
                    case SSL_KETSTORE_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    case SSL_KETSTORE_PASSWORD_ATTRIBUTE: {
                        node.get(element.getModelName()).setExpression(attrValue);
                        continue block7;
                    }
                    case SSL_KETSTORE_TYPE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    case SSL_KETSTORE_ALIAS_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    case SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE: {
                        node.get(element.getModelName()).setExpression(attrValue);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseTruststore(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SSL_TRUSTSTORE_ELEMENT);
                switch (element) {
                    case SSL_TRUSTSTORE_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block4;
                    }
                    case SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE: {
                        node.get(element.getModelName()).setExpression(attrValue);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseBufferService(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.BUFFER_SERVICE_ELEMENT);
                switch (element) {
                    case USE_DISK_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block15;
                    }
                    case INLINE_LOBS: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block15;
                    }
                    case PROCESSOR_BATCH_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block15;
                    }
                    case CONNECTOR_BATCH_SIZE_ATTRIBUTE: {
                        continue block15;
                    }
                    case MAX_PROCESSING_KB_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block15;
                    }
                    case MAX_RESERVED_KB_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block15;
                    }
                    case MAX_OPEN_FILES_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block15;
                    }
                    case MAX_FILE_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Long.parseLong(attrValue));
                        continue block15;
                    }
                    case MAX_BUFFER_SPACE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Long.parseLong(attrValue));
                        continue block15;
                    }
                    case MEMORY_BUFFER_SPACE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block15;
                    }
                    case MEMORY_BUFFER_OFFHEAP_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block15;
                    }
                    case MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block15;
                    }
                    case ENCRYPT_FILES_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block15;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parsePreparedPlanCacheConfiguration(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.PREPAREDPLAN_CACHE_ELEMENT);
                switch (element) {
                    case PPC_CONTAINER_NAME_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block5;
                    }
                    case PPC_ENABLE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block5;
                    }
                    case PPC_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseResultsetCacheConfiguration(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.RESULTSET_CACHE_ELEMENT);
                switch (element) {
                    case RSC_CONTAINER_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case RSC_ENABLE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block6;
                    }
                    case RSC_MAX_STALENESS_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block6;
                    }
                    case RSC_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private String parseTranslator(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String translatorName = null;
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName);
                switch (element) {
                    case TRANSPORT_NAME_ATTRIBUTE: 
                    case TRANSLATOR_NAME_ATTRIBUTE: {
                        translatorName = attrValue;
                        continue block4;
                    }
                    case TRANSLATOR_MODULE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return translatorName;
    }
}

