/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.rest.RestASMBasedWebArchiveBuilder;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;

public class ResteasyEnabler
implements VDBLifeCycleListener {
    static final String REST_NAMESPACE = "{http://teiid.org/rest}";
    private Admin admin;
    private Executor executor;
    private String vdbName;
    private int vdbVersion;
    private AtomicBoolean deployed = new AtomicBoolean(false);
    private ContainerLifeCycleListener shutdownListener;

    public ResteasyEnabler(String vdbName, int version, ModelController deployer, Executor executor, ContainerLifeCycleListener shutdownListener) {
        this.admin = AdminFactory.getInstance().createAdmin(deployer.createClient(executor));
        this.executor = executor;
        this.vdbName = vdbName;
        this.vdbVersion = version;
        this.shutdownListener = shutdownListener;
    }

    public synchronized void added(String name, int version, CompositeVDB vdb, boolean reloading) {
    }

    public void beforeRemove(String name, int version, CompositeVDB cvdb) {
        if (this.vdbName.equals(name) && this.vdbVersion == version) {
            final String warName = this.buildName(name, version);
            if (this.deployed.get()) {
                this.deployed.set(false);
                if (!this.shutdownListener.isShutdownInProgress()) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((AdminFactory.AdminImpl)ResteasyEnabler.this.admin).undeploy(warName, true);
                            }
                            catch (AdminException e) {
                                LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.getString("failed_to_remove", new Object[]{warName}));
                            }
                        }
                    });
                }
            }
        }
    }

    public synchronized void finishedDeployment(String name, int version, CompositeVDB cvdb, boolean reloading) {
        if (this.vdbName.equals(name) && this.vdbVersion == version) {
            final VDBMetaData vdb = cvdb.getVDB();
            if (!vdb.getStatus().equals((Object)VDB.Status.ACTIVE)) {
                return;
            }
            String generate = vdb.getPropertyValue("{http://teiid.org/rest}auto-generate");
            final String warName = this.buildName(name, version);
            if (generate != null && Boolean.parseBoolean(generate) && this.hasRestMetadata(vdb) && !this.deployed.get() && !reloading) {
                this.deployed.set(true);
                final Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
                            byte[] warContents = builder.createRestArchive(vdb);
                            ((AdminFactory.AdminImpl)ResteasyEnabler.this.admin).deploy(warName, (InputStream)new ByteArrayInputStream(warContents), true);
                        }
                        catch (FileNotFoundException e) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.getString("failed_to_add", new Object[]{warName}));
                        }
                        catch (IOException e) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.getString("failed_to_add", new Object[]{warName}));
                        }
                        catch (AdminException e) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.getString("failed_to_add", new Object[]{warName}));
                        }
                    }
                };
                if (!((AdminFactory.AdminImpl)this.admin).getDeployments().contains(warName)) {
                    this.executor.execute(job);
                } else {
                    Timer timer = new Timer("teiid-war-deployer", true);
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            if (!((AdminFactory.AdminImpl)ResteasyEnabler.this.admin).getDeployments().contains(warName)) {
                                ResteasyEnabler.this.executor.execute(job);
                            } else {
                                LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.getString("failed_to_add", new Object[]{warName}));
                            }
                        }
                    };
                    timer.schedule(task, 3000L);
                }
            }
        }
    }

    public synchronized void removed(String name, int version, CompositeVDB cvdb) {
    }

    private String buildName(String name, int version) {
        return name + "_" + version + ".war";
    }

    private boolean hasRestMetadata(VDBMetaData vdb) {
        String securityType = vdb.getPropertyValue("{http://teiid.org/rest}security-type");
        if (securityType != null && !securityType.equalsIgnoreCase("none") && !securityType.equalsIgnoreCase("httpbasic")) {
            return false;
        }
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            Schema schema = metadataStore.getSchema(model.getName());
            if (schema == null) continue;
            Collection procedures = schema.getProcedures().values();
            for (Procedure procedure : procedures) {
                String uri = procedure.getProperty("{http://teiid.org/rest}URI", false);
                String method = procedure.getProperty("{http://teiid.org/rest}METHOD", false);
                if (uri == null || method == null) continue;
                return true;
            }
        }
        return false;
    }
}

