/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.jboss.BaseCachehandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.logging.LogManager;

class ClearCache
extends BaseCachehandler {
    protected ClearCache() {
        super("clear-cache", true);
    }

    @Override
    protected void executeOperation(OperationContext context, SessionAwareCache cache, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.CACHE_TYPE.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.CACHE_TYPE.getName() + ".missing")));
        }
        String cacheType = operation.get(OperationsConstants.CACHE_TYPE.getName()).asString();
        if (cache == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50071, new Object[]{cacheType})));
        }
        if (operation.hasDefined(OperationsConstants.VDB_NAME.getName()) && operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
            int vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt();
            TeiidOperationHandler.checkVDB(context, vdbName, vdbVersion);
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50005, new Object[]{cacheType, vdbName, vdbVersion}));
            cache.clearForVDB(vdbName, vdbVersion);
        } else {
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50098, new Object[]{cacheType}));
            cache.clearAll();
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.CACHE_TYPE);
        builder.addParameter((AttributeDefinition)OperationsConstants.OPTIONAL_VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.OPTIONAL_VDB_VERSION);
    }
}

