/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TeiidServiceNames;

class MarkDataSourceAvailable
extends TeiidOperationHandler {
    protected MarkDataSourceAvailable() {
        super("mark-datasource-available", true);
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.DS_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.DS_NAME.getName() + ".missing")));
        }
        String dsName = operation.get(OperationsConstants.DS_NAME.getName()).asString();
        ServiceController sc = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.VDB_STATUS_CHECKER);
        VDBStatusChecker vsc = (VDBStatusChecker)VDBStatusChecker.class.cast(sc.getValue());
        vsc.dataSourceAdded(dsName, null);
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.DS_NAME);
    }
}

