/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;
import org.teiid.core.util.StringUtil;

public class JBossLogger
implements org.teiid.logging.Logger {
    private ConcurrentHashMap<String, Logger> loggers = new ConcurrentHashMap();

    public boolean isEnabled(String context, int level) {
        if (context == null) {
            return false;
        }
        Logger.Level logLevel = JBossLogger.convert2JbossLevel(level);
        Logger log = this.getLogger(context);
        return log.isEnabled(logLevel);
    }

    public void log(int level, String context, Object ... msg) {
        this.log(level, context, null, msg);
    }

    public void log(int level, String context, Throwable t, Object ... msg) {
        Logger logger = this.getLogger(context);
        Logger.Level jbossLevel = JBossLogger.convert2JbossLevel(level);
        if (msg.length == 0) {
            logger.log(jbossLevel, null, t);
        } else if (msg.length == 1 && !(msg[0] instanceof String)) {
            String msgStr = StringUtil.toString((Object[])msg, (String)" ", (boolean)false);
            if (msgStr.indexOf(37) > -1) {
                msgStr = StringUtil.replaceAll((String)msgStr, (String)"%", (String)"%%");
            }
            logger.logf(jbossLevel, t, msgStr, msg);
        } else {
            logger.log(jbossLevel, (Object)StringUtil.toString((Object[])msg, (String)" ", (boolean)false), t);
        }
    }

    public static Logger.Level convert2JbossLevel(int level) {
        switch (level) {
            case 1: {
                return Logger.Level.FATAL;
            }
            case 2: {
                return Logger.Level.ERROR;
            }
            case 3: {
                return Logger.Level.WARN;
            }
            case 4: {
                return Logger.Level.INFO;
            }
            case 5: {
                return Logger.Level.DEBUG;
            }
            case 6: {
                return Logger.Level.TRACE;
            }
        }
        return Logger.Level.DEBUG;
    }

    public static int convert2MessageLevel(Logger.Level level) {
        switch (level) {
            case FATAL: {
                return 1;
            }
            case ERROR: {
                return 2;
            }
            case WARN: {
                return 3;
            }
            case INFO: {
                return 4;
            }
            case DEBUG: {
                return 5;
            }
            case TRACE: {
                return 0;
            }
        }
        return 5;
    }

    private Logger getLogger(String context) {
        Logger logger = this.loggers.get(context);
        if (logger == null) {
            logger = Logger.getLogger((String)context);
            this.loggers.put(context, logger);
        }
        return logger;
    }

    public void shutdown() {
    }

    public void putMdc(String key, String val) {
        MDC.put((String)key, (Object)val);
    }

    public void removeMdc(String key) {
        MDC.remove((String)key);
    }
}

