/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TransportService;

class ListSessions
extends TeiidOperationHandler {
    protected ListSessions() {
        super("list-sessions");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        String vdbName = null;
        int version = -1;
        boolean filter = false;
        if (operation.hasDefined(OperationsConstants.OPTIONAL_VDB_VERSION.getName()) && operation.hasDefined(OperationsConstants.OPTIONAL_VDB_NAME.getName())) {
            vdbName = operation.get(OperationsConstants.OPTIONAL_VDB_NAME.getName()).asString();
            version = operation.get(OperationsConstants.OPTIONAL_VDB_VERSION.getName()).asInt();
            ListSessions.checkVDB(context, vdbName, version);
            filter = true;
        }
        ModelNode result = context.getResult();
        for (TransportService t : this.getTransportServices(context)) {
            Collection<SessionMetadata> sessions = t.getActiveSessions();
            for (SessionMetadata session : sessions) {
                if (filter) {
                    if (!session.getVDBName().equals(vdbName) || session.getVDBVersion() != version) continue;
                    VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, result.add());
                    continue;
                }
                VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, result.add());
            }
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.OPTIONAL_VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.OPTIONAL_VDB_VERSION);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.SessionMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

