/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import junit.framework.TestCase;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.plugins.JBossSecurityContext;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.jboss.JBossSecurityHelper;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.SessionServiceImpl;

public class TestJBossSecurityHelper
extends TestCase {
    private JBossSecurityHelper buildSecurityHelper(final String domain, final SecurityDomainContext sdc) throws Exception {
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.stub((Object)p.getName()).toReturn((Object)"alreadylogged");
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(p);
        final Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        JBossSecurityHelper sh = new JBossSecurityHelper(){

            public Subject getSubjectInContext(String securityDomain) {
                if (securityDomain.equals("passthrough")) {
                    return subject;
                }
                return null;
            }

            protected SecurityDomainContext getSecurityDomainContext(String securityDomain) {
                if (securityDomain.equals(domain)) {
                    return sdc;
                }
                return null;
            }
        };
        return sh;
    }

    public void testAuthenticate() throws Exception {
        Credentials credentials = new Credentials("pass1".toCharArray());
        String domains = "testFile";
        SecurityDomainContext securityContext = (SecurityDomainContext)Mockito.mock(SecurityDomainContext.class);
        JBossSecurityHelper ms = this.buildSecurityHelper(domains, securityContext);
        AuthenticationManager authManager = new AuthenticationManager(){

            public String getSecurityDomain() {
                return null;
            }

            public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
                return true;
            }

            public boolean isValid(Principal principal, Object credential) {
                return true;
            }

            public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap) {
                return null;
            }

            public Subject getActiveSubject() {
                return null;
            }

            public void logout(Principal arg0, Subject arg1) {
            }
        };
        Mockito.stub((Object)securityContext.getAuthenticationManager()).toReturn((Object)authManager);
        SecurityContext c = ms.authenticate(domains, "user1", credentials, null);
        TestJBossSecurityHelper.assertTrue((boolean)(c instanceof JBossSecurityContext));
        TestJBossSecurityHelper.assertEquals((String)domains, (String)((JBossSecurityContext)c).getSecurityDomain());
    }

    public void validateSession(boolean securityEnabled) throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("somedomain");
        SecurityDomainContext securityContext = (SecurityDomainContext)Mockito.mock(SecurityDomainContext.class);
        AuthenticationManager authManager = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.stub((Object)authManager.isValid((Principal)new SimplePrincipal("steve"), (Object)"pass1", new Subject())).toReturn((Object)true);
        Mockito.stub((Object)securityContext.getAuthenticationManager()).toReturn((Object)authManager);
        SessionServiceImpl jss = new SessionServiceImpl(){

            protected VDBMetaData getActiveVDB(String vdbName, String vdbVersion) throws SessionServiceException {
                return (VDBMetaData)Mockito.mock(VDBMetaData.class);
            }
        };
        jss.setSecurityHelper((SecurityHelper)this.buildSecurityHelper("somedomain", securityContext));
        jss.setSecurityDomain("somedomain");
        try {
            jss.validateSession(String.valueOf(1));
            TestJBossSecurityHelper.fail((String)"exception expected");
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        SessionMetadata info = jss.createSession("x", "1", AuthenticationType.USERPASSWORD, "steve", new Credentials("pass1".toCharArray()), "foo", new Properties());
        if (securityEnabled) {
            ((AuthenticationManager)Mockito.verify((Object)authManager)).isValid((Principal)new SimplePrincipal("steve"), (Object)"pass1", new Subject());
        }
        String id1 = info.getSessionId();
        jss.validateSession(id1);
        TestJBossSecurityHelper.assertEquals((int)1, (int)jss.getActiveSessionsCount());
        TestJBossSecurityHelper.assertEquals((int)0, (int)jss.getSessionsLoggedInToVDB("a", 1).size());
        jss.closeSession(id1);
        try {
            jss.validateSession(id1);
            TestJBossSecurityHelper.fail((String)"exception expected");
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        try {
            jss.closeSession(id1);
            TestJBossSecurityHelper.fail((String)"exception expected");
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    @Test
    public void testvalidateSession() throws Exception {
        this.validateSession(true);
    }

    @Test
    public void testvalidateSession2() throws Exception {
        this.validateSession(false);
    }
}

