/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.models.Model;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.swagger.util.ModelDeserializer;
import io.swagger.util.ParameterDeserializer;
import io.swagger.util.PropertyDeserializer;
import io.swagger.util.SecurityDefinitionDeserializer;

public class Yaml {
    static ObjectMapper mapper;

    public static ObjectMapper mapper() {
        if (mapper == null) {
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            SimpleModule module = new SimpleModule();
            module.addDeserializer(Model.class, (JsonDeserializer)new ModelDeserializer());
            module.addDeserializer(Property.class, (JsonDeserializer)new PropertyDeserializer());
            module.addDeserializer(Parameter.class, (JsonDeserializer)new ParameterDeserializer());
            module.addDeserializer(SecuritySchemeDefinition.class, (JsonDeserializer)new SecurityDefinitionDeserializer());
            mapper.registerModule((Module)module);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return mapper;
    }

    public static ObjectWriter pretty() {
        return Yaml.mapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public static void prettyPrint(Object o) {
        try {
            System.out.println(Yaml.pretty().writeValueAsString(o));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

