/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.EncryptedStorageManager;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.dqp.service.BufferService;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;

public class BufferServiceImpl
implements BufferService,
Serializable {
    private static final long serialVersionUID = -6217808623863643531L;
    private static final long MB = 0x100000L;
    private BufferManagerImpl bufferMgr;
    private File bufferDir;
    private boolean useDisk = true;
    private boolean encryptFiles = false;
    private int processorBatchSize = 256;
    private int maxOpenFiles = 64;
    private long maxFileSize = 2048L;
    private int maxProcessingKb = -1;
    private int maxReserveKb = -1;
    private long maxBufferSpace = 51200L;
    private boolean inlineLobs = true;
    private long memoryBufferSpace = -1L;
    private int maxStorageObjectSize = 0x800000;
    private boolean memoryBufferOffHeap;
    private FileStorageManager fsm;
    private BufferFrontedFileStoreCache fsc;
    private int workingMaxReserveKb;

    void cleanDirectory(File file) {
        FileUtils.removeChildrenRecursively((File)file);
    }

    public void start() {
        try {
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.setProcessorBatchSize(this.processorBatchSize);
            this.bufferMgr.setMaxReserveKB(this.maxReserveKb);
            this.bufferMgr.setMaxProcessingKB(this.maxProcessingKb);
            this.bufferMgr.setInlineLobs(this.inlineLobs);
            this.bufferMgr.initialize();
            if (this.useDisk) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Starting BufferManager using", (Object)this.bufferDir);
                if (!this.bufferDir.exists()) {
                    this.bufferDir.mkdirs();
                }
                this.cleanDirectory(this.bufferDir);
                this.fsm = new FileStorageManager();
                this.fsm.setStorageDirectory(this.bufferDir.getCanonicalPath());
                this.fsm.setMaxOpenFiles(this.maxOpenFiles);
                this.fsm.setMaxBufferSpace(this.maxBufferSpace * 0x100000L);
                SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)this.fsm);
                ssm.setMaxFileSize(this.maxFileSize);
                SplittableStorageManager sm = ssm;
                if (this.encryptFiles) {
                    sm = new EncryptedStorageManager((StorageManager)ssm);
                }
                this.fsc = new BufferFrontedFileStoreCache();
                this.fsc.setBufferManager(this.bufferMgr);
                this.fsc.setMaxStorageObjectSize(this.maxStorageObjectSize);
                this.fsc.setDirect(this.memoryBufferOffHeap);
                long autoMaxBufferSpace = 4L * ((long)this.bufferMgr.getMaxReserveKB() << 10) / 10L;
                if (this.memoryBufferSpace < 0L) {
                    this.fsc.setMemoryBufferSpace(autoMaxBufferSpace);
                } else {
                    this.fsc.setMemoryBufferSpace(this.memoryBufferSpace << 20);
                }
                long batchAndInodeOverheadKB = this.fsc.getMemoryBufferSpace() >> (this.memoryBufferOffHeap ? 19 : 17);
                this.bufferMgr.setMaxReserveKB((int)Math.max(0L, (long)this.bufferMgr.getMaxReserveKB() - batchAndInodeOverheadKB));
                if (this.maxReserveKb < 0) {
                    if (this.memoryBufferOffHeap) {
                        this.bufferMgr.setMaxReserveKB(8 * this.bufferMgr.getMaxReserveKB() / 10);
                    } else {
                        this.bufferMgr.setMaxReserveKB((int)Math.max(0L, (long)this.bufferMgr.getMaxReserveKB() - (this.fsc.getMemoryBufferSpace() >> 10)));
                    }
                }
                this.fsc.setStorageManager((StorageManager)sm);
                this.fsc.initialize();
                this.bufferMgr.setCache((Cache)this.fsc);
                this.workingMaxReserveKb = this.bufferMgr.getMaxReserveKB();
            } else {
                this.bufferMgr.setCache((Cache)new MemoryStorageManager());
            }
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, new Object[0]));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, new Object[0]));
        }
    }

    public void stop() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Stopping BufferManager using", (Object)this.bufferDir);
        if (this.bufferMgr != null) {
            this.bufferMgr.shutdown();
            this.bufferMgr = null;
        }
        if (this.bufferDir != null) {
            this.cleanDirectory(this.bufferDir);
            this.bufferDir.delete();
        }
    }

    public BufferManagerImpl getBufferManager() {
        return this.bufferMgr;
    }

    public TupleBufferCache getTupleBufferCache() {
        return this.bufferMgr;
    }

    public void setUseDisk(boolean flag) {
        this.useDisk = flag;
    }

    public void setDiskDirectory(String dir) {
        this.bufferDir = new File(dir, "buffer");
    }

    public void setProcessorBatchSize(int size) {
        this.processorBatchSize = size;
    }

    public void setInlineLobs(boolean inlineLobs) {
        this.inlineLobs = inlineLobs;
    }

    public File getBufferDirectory() {
        return this.bufferDir;
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    public boolean isInlineLobs() {
        return this.inlineLobs;
    }

    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getMaxProcessingKb() {
        return this.maxProcessingKb;
    }

    public int getMaxReservedKb() {
        return this.maxReserveKb;
    }

    public void setMaxProcessingKb(int maxProcessingKb) {
        this.maxProcessingKb = maxProcessingKb;
    }

    public void setMaxReserveKb(int maxReserveKb) {
        this.maxReserveKb = maxReserveKb;
    }

    public long getMaxBufferSpace() {
        return this.maxBufferSpace;
    }

    public void setMaxBufferSpace(long maxBufferSpace) {
        this.maxBufferSpace = maxBufferSpace;
    }

    public void setMemoryBufferOffHeap(boolean memoryBufferOffHeap) {
        this.memoryBufferOffHeap = memoryBufferOffHeap;
    }

    public void setMemoryBufferSpace(int memoryBufferSpace) {
        this.memoryBufferSpace = memoryBufferSpace;
    }

    public void setMaxStorageObjectSize(int maxStorageObjectSize) {
        this.maxStorageObjectSize = maxStorageObjectSize;
    }

    public long getUsedDiskBufferSpaceMB() {
        if (this.fsm != null) {
            return this.fsm.getUsedBufferSpace() / 0x100000L;
        }
        return 0L;
    }

    public long getHeapCacheMemoryInUseKB() {
        return this.bufferMgr.getActiveBatchBytes() / 1024L;
    }

    public long getHeapMemoryInUseByActivePlansKB() {
        return (long)this.workingMaxReserveKb - this.bufferMgr.getReserveBatchBytes() / 1024L;
    }

    public long getDiskReadCount() {
        if (this.fsc != null) {
            return this.fsc.getStorageReads();
        }
        return 0L;
    }

    public long getDiskWriteCount() {
        if (this.fsc != null) {
            return this.fsc.getStorageWrites();
        }
        return 0L;
    }

    public long getMemoryBufferUsedKB() {
        if (this.fsc != null) {
            return this.fsc.getMemoryInUseBytes() >> 10;
        }
        return 0L;
    }

    public long getCacheReadCount() {
        return this.bufferMgr.getReadCount();
    }

    public long getCacheWriteCount() {
        return this.bufferMgr.getWriteCount();
    }

    public long getReadAttempts() {
        return this.bufferMgr.getReadAttempts();
    }

    public int getMemoryBufferSpace() {
        return (int)this.memoryBufferSpace;
    }

    public int getMaxStorageObjectSize() {
        return this.maxStorageObjectSize;
    }

    public boolean isMemoryBufferOffHeap() {
        return this.memoryBufferOffHeap;
    }

    public boolean isEncryptFiles() {
        return this.encryptFiles;
    }

    public void setEncryptFiles(boolean encryptFiles) {
        this.encryptFiles = encryptFiles;
    }
}

