/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.io.File;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.teiid.connector.DataPlugin;
import org.teiid.core.util.FileUtils;

public interface FileConnection
extends Connection {
    public File getFile(String var1) throws ResourceException;

    public static class Util {
        public static File[] getFiles(String location, FileConnection fc, boolean exceptionIfFileNotFound) throws ResourceException {
            File datafile = fc.getFile(location);
            if (datafile.isDirectory()) {
                return datafile.listFiles();
            }
            String fname = datafile.getName();
            String ext = FileUtils.getExtension((String)fname);
            File parentDir = datafile.getParentFile();
            if (ext != null && "*".equals(FileUtils.getBaseFileNameWithoutExtension((String)fname))) {
                return FileUtils.findAllFilesInDirectoryHavingExtension((String)parentDir.getAbsolutePath(), (String)("." + ext));
            }
            if (!datafile.exists()) {
                if (exceptionIfFileNotFound) {
                    throw new ResourceException(DataPlugin.Util.gs("file_not_found", new Object[]{location}));
                }
                return null;
            }
            return new File[]{datafile};
        }
    }
}

