/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;

public class CollectionTupleSource
implements TupleSource {
    public static final List<Integer> UPDATE_ROW = Arrays.asList(1);
    private Iterator<? extends List<?>> tuples;

    public static CollectionTupleSource createUpdateCountTupleSource(int count) {
        return new CollectionTupleSource(Arrays.asList(Arrays.asList(count)).iterator());
    }

    public static TupleSource createUpdateCountArrayTupleSource(final int count) {
        return new TupleSource(){
            int index = 0;

            @Override
            public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
                if (this.index++ < count) {
                    return UPDATE_ROW;
                }
                return null;
            }

            @Override
            public void closeSource() {
            }
        };
    }

    public static CollectionTupleSource createNullTupleSource() {
        return new CollectionTupleSource(new ArrayList(0).iterator());
    }

    public CollectionTupleSource(Iterator<? extends List<?>> tuples) {
        this.tuples = tuples;
    }

    @Override
    public List<?> nextTuple() {
        if (this.tuples.hasNext()) {
            return this.tuples.next();
        }
        return null;
    }

    @Override
    public void closeSource() {
    }
}

