/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.List;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public abstract class AbstractSymbolMappingVisitor
extends ExpressionMappingVisitor {
    private List unmappedSymbols;

    protected AbstractSymbolMappingVisitor() {
        super(null);
    }

    protected abstract Symbol getMappedSymbol(Symbol var1);

    @Override
    public void visit(Insert obj) {
        ArrayList<ElementSymbol> physicalElements = new ArrayList<ElementSymbol>();
        GroupSymbol virtualGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(virtualGroup));
        if (obj.getVariables() != null) {
            for (ElementSymbol virtualElement : obj.getVariables()) {
                physicalElements.add(this.getMappedElement(virtualElement));
            }
            obj.setVariables(physicalElements);
        }
    }

    @Override
    public void visit(Delete obj) {
        GroupSymbol virtualGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(virtualGroup));
    }

    @Override
    public void visit(Update obj) {
        GroupSymbol virtualGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(virtualGroup));
    }

    @Override
    public void visit(SetClause obj) {
        obj.setSymbol(this.getMappedElement(obj.getSymbol()));
    }

    @Override
    public void visit(MultipleElementSymbol obj) {
        List<ElementSymbol> oldSymbols = obj.getElementSymbols();
        if (oldSymbols != null && oldSymbols.size() > 0) {
            ArrayList<ElementSymbol> newSymbols = new ArrayList<ElementSymbol>(oldSymbols.size());
            for (ElementSymbol es : oldSymbols) {
                ElementSymbol mappedSymbol = this.getMappedElement(es);
                newSymbols.add(mappedSymbol);
            }
            obj.setElementSymbols(newSymbols);
        }
        if (obj.getGroup() == null) {
            return;
        }
        obj.setGroup(this.getMappedGroup(obj.getGroup()));
    }

    @Override
    public void visit(UnaryFromClause obj) {
        GroupSymbol srcGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(srcGroup));
    }

    @Override
    public void visit(StoredProcedure obj) {
        String execName = obj.getProcedureName();
        GroupSymbol fakeGroup = new GroupSymbol(execName);
        Object procedureID = obj.getProcedureID();
        if (procedureID != null) {
            fakeGroup.setMetadataID(procedureID);
        }
        GroupSymbol mappedGroup = this.getMappedGroup(fakeGroup);
        obj.setProcedureName(mappedGroup.getName());
        super.visit(obj);
    }

    @Override
    public Expression replaceExpression(Expression element) {
        if (element instanceof ElementSymbol) {
            return this.getMappedElement((ElementSymbol)element);
        }
        return element;
    }

    private ElementSymbol getMappedElement(ElementSymbol obj) {
        ElementSymbol element = (ElementSymbol)this.getMappedSymbol(obj);
        if (element != null) {
            return element;
        }
        this.markUnmapped(obj);
        return obj;
    }

    private GroupSymbol getMappedGroup(GroupSymbol obj) {
        GroupSymbol group = (GroupSymbol)this.getMappedSymbol(obj);
        if (group != null) {
            return group;
        }
        this.markUnmapped(obj);
        return obj;
    }

    private void markUnmapped(Symbol symbol) {
        if (this.unmappedSymbols == null) {
            this.unmappedSymbols = new ArrayList();
        }
        this.unmappedSymbols.add(symbol);
    }

    public List getUnmappedSymbols() {
        return this.unmappedSymbols;
    }
}

