/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.utils;

import com.google.common.base.Function;
import io.swagger.converter.PrimitiveType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Type typeFromString(String type) {
        PrimitiveType primitive = PrimitiveType.fromName((String)type);
        if (primitive != null) {
            return primitive.getType();
        }
        try {
            return Class.forName(type);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to resolve '%s' into class", type), (Throwable)e);
            return null;
        }
    }

    public static boolean isOverriddenMethod(Method methodToFind, Class<?> cls) {
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && !superClass.getClass().equals(Object.class)) {
            for (Method method : superClass.getMethods()) {
                if (!method.getName().equals(methodToFind.getName()) || !method.getReturnType().isAssignableFrom(methodToFind.getReturnType()) || !Arrays.equals(method.getParameterTypes(), methodToFind.getParameterTypes()) || Arrays.equals(method.getGenericParameterTypes(), methodToFind.getGenericParameterTypes())) continue;
                return true;
            }
            return ReflectionUtils.isOverriddenMethod(methodToFind, superClass);
        }
        return false;
    }

    public static Method getOverriddenMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> superClass = declaringClass.getSuperclass();
        if (superClass != null && !superClass.getClass().equals(Object.class)) {
            Method result = ReflectionUtils.findMethod(method, superClass);
            if (result == null) {
                for (Class<?> anInterface : declaringClass.getInterfaces()) {
                    result = ReflectionUtils.findMethod(method, anInterface);
                    if (result == null) continue;
                    return result;
                }
            } else {
                return result;
            }
        }
        return null;
    }

    public static Method findMethod(Method methodToFind, Class<?> cls) {
        String methodToSearch = methodToFind.getName();
        Class<?>[] soughtForParameterType = methodToFind.getParameterTypes();
        Type[] soughtForGenericParameterType = methodToFind.getGenericParameterTypes();
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodToSearch) || !method.getReturnType().isAssignableFrom(methodToFind.getReturnType())) continue;
            Class<?>[] srcParameterTypes = method.getParameterTypes();
            Type[] srcGenericParameterTypes = method.getGenericParameterTypes();
            if (soughtForParameterType.length != srcParameterTypes.length || soughtForGenericParameterType.length != srcGenericParameterTypes.length || !ReflectionUtils.hasIdenticalParameters(srcParameterTypes, soughtForParameterType, srcGenericParameterTypes, soughtForGenericParameterType)) continue;
            return method;
        }
        return null;
    }

    private static boolean hasIdenticalParameters(Class<?>[] srcParameterTypes, Class<?>[] soughtForParameterType, Type[] srcGenericParameterTypes, Type[] soughtForGenericParameterType) {
        for (int j = 0; j < soughtForParameterType.length; ++j) {
            Class<?> parameterType = soughtForParameterType[j];
            if (srcParameterTypes[j].equals(parameterType) || !srcGenericParameterTypes[j].equals(soughtForGenericParameterType[j]) && srcParameterTypes[j].isAssignableFrom(parameterType)) continue;
            return false;
        }
        return true;
    }

    public static Function<Annotation, Class<? extends Annotation>> createAnnotationTypeGetter() {
        return new Function<Annotation, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(Annotation annotation) {
                return annotation.annotationType();
            }
        };
    }

    public static boolean isContext(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Context)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInject(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!"javax.inject.Inject".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstructorCompatible(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            int access = 7;
            return constructor.getParameterTypes().length == 0 && (constructor.getDeclaringClass().getModifiers() & 7) == constructor.getModifiers();
        }
        return true;
    }
}

