/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.Serializable;
import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectInfo;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.jboss.security.negotiation.spnego.KerberosMessage;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.SecurityActions;
import org.teiid.logging.LogManager;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;

public class JBossSecurityHelper
implements SecurityHelper,
Serializable {
    private static final long serialVersionUID = 3598997061994110254L;
    public static final String AT = "@";

    public SecurityContext associateSecurityContext(Object newContext) {
        SecurityContext context = SecurityActions.getSecurityContext();
        if (newContext != context) {
            SecurityActions.setSecurityContext((SecurityContext)newContext);
        }
        return context;
    }

    public void clearSecurityContext() {
        SecurityActions.clearSecurityContext();
    }

    public SecurityContext getSecurityContext() {
        return SecurityActions.getSecurityContext();
    }

    public SecurityContext createSecurityContext(String securityDomain, Principal p, Object credentials, Subject subject) {
        return SecurityActions.createSecurityContext(p, credentials, subject, securityDomain);
    }

    public Subject getSubjectInContext(String securityDomain) {
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null && sc.getSecurityDomain().equals(securityDomain)) {
            return this.getSubjectInContext(sc);
        }
        return null;
    }

    public Subject getSubjectInContext(Object context) {
        if (!(context instanceof SecurityContext)) {
            return null;
        }
        SecurityContext sc = (SecurityContext)context;
        SubjectInfo si = sc.getSubjectInfo();
        Subject subject = si.getAuthenticatedSubject();
        return subject;
    }

    public SecurityContext authenticate(String domain, String baseUsername, Credentials credentials, String applicationName) throws LoginException {
        Subject subject;
        String credString;
        SimplePrincipal userPrincipal;
        boolean isValid;
        AuthenticationManager authManager;
        SecurityDomainContext securityDomainContext = this.getSecurityDomainContext(domain);
        if (securityDomainContext != null && (authManager = securityDomainContext.getAuthenticationManager()) != null && (isValid = authManager.isValid((Principal)(userPrincipal = new SimplePrincipal(baseUsername)), (Object)(credString = credentials == null ? null : new String(credentials.getCredentialsAsCharArray())), subject = new Subject()))) {
            SecurityContext securityContext = this.createSecurityContext(domain, (Principal)userPrincipal, credString, subject);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful for \"", baseUsername, "\" in security domain", domain});
            return securityContext;
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50072, new Object[]{baseUsername, domain}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
        AuthenticationManager authManager;
        SecurityDomainContext securityDomainContext = this.getSecurityDomainContext(securityDomain);
        if (securityDomainContext != null && (authManager = securityDomainContext.getAuthenticationManager()) != null) {
            NegotiationContext context;
            SecurityContext previous;
            block7: {
                LoginException le;
                block8: {
                    SecurityContext securityContext;
                    block6: {
                        GSSResult gSSResult;
                        previous = null;
                        context = new NegotiationContext();
                        context.setRequestMessage((NegotiationMessage)new KerberosMessage(Constants.KERBEROS_V5, serviceTicket));
                        try {
                            context.associate();
                            securityContext = this.createSecurityContext(securityDomain, (Principal)new SimplePrincipal("temp"), null, new Subject());
                            previous = this.associateSecurityContext(securityContext);
                            Subject subject = new Subject();
                            boolean isValid = authManager.isValid(null, null, subject);
                            if (!isValid) break block6;
                            Principal principal = null;
                            Iterator<Principal> iterator = subject.getPrincipals().iterator();
                            if (iterator.hasNext()) {
                                Principal p;
                                principal = p = iterator.next();
                            }
                            SecurityContext sc = this.createSecurityContext(securityDomain, principal, null, subject);
                            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful though GSS API"});
                            GSSResult result = this.buildGSSResult(context, securityDomain, true);
                            result.setSecurityContext((Object)sc);
                            result.setUserName(principal.getName());
                            gSSResult = result;
                            this.associateSecurityContext(previous);
                        }
                        catch (Throwable throwable) {
                            this.associateSecurityContext(previous);
                            context.clear();
                            throw throwable;
                        }
                        context.clear();
                        return gSSResult;
                    }
                    le = (LoginException)securityContext.getData().get("org.jboss.security.exception");
                    if (le == null) break block7;
                    if (!le.getMessage().equals("Continuation Required.")) break block8;
                    GSSResult gSSResult = this.buildGSSResult(context, securityDomain, false);
                    this.associateSecurityContext(previous);
                    context.clear();
                    return gSSResult;
                }
                throw le;
            }
            this.associateSecurityContext(previous);
            context.clear();
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50072, new Object[]{"GSS Auth", securityDomain}));
    }

    private GSSResult buildGSSResult(NegotiationContext context, String securityDomain, boolean validAuth) throws LoginException {
        GSSContext securityContext = (GSSContext)context.getSchemeContext();
        try {
            if (context.getResponseMessage() == null && validAuth) {
                return new GSSResult(context.isAuthenticated(), securityContext.getCredDelegState() ? securityContext.getDelegCred() : null);
            }
            if (context.getResponseMessage() instanceof KerberosMessage) {
                KerberosMessage km = (KerberosMessage)context.getResponseMessage();
                return new GSSResult(km.getToken(), context.isAuthenticated(), securityContext.getCredDelegState() ? securityContext.getDelegCred() : null);
            }
        }
        catch (GSSException e) {
            throw new LoginException(e.getMessage());
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50103, new Object[]{securityDomain}));
    }

    protected SecurityDomainContext getSecurityDomainContext(String securityDomain) {
        if (securityDomain != null && !securityDomain.isEmpty()) {
            ServiceName name = ServiceName.JBOSS.append(new String[]{"security", "security-domain", securityDomain});
            ServiceController controller = CurrentServiceContainer.getServiceContainer().getService(name);
            if (controller != null) {
                return (SecurityDomainContext)controller.getService().getValue();
            }
        }
        return null;
    }
}

