/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import nu.xom.Builder;
import nu.xom.Document;
import nux.xom.pool.BuilderFactory;
import nux.xom.sandbox.IOTest;
import nux.xom.sandbox.IOTestUtil;

public class SchemaValidatingBuilderTest
extends IOTest {
    private static final boolean USE_SCHEMA_VALIDATING_BUILDER = true;

    public static void main(String[] args) throws Exception {
        System.setProperty("nu.xom.Verifier.checkURI", "false");
        int k = 0;
        Builder pooledBuilder = SchemaValidatingBuilderTest.getW3CBuilder();
        int i = 0;
        while (i < args.length) {
            File[] files = IOTestUtil.listXMLFiles(args[i], "*.xml");
            int q = 0;
            while (q < 1) {
                int j = 0;
                while (j < files.length) {
                    File file = files[j];
                    if (SchemaValidatingBuilderTest.bogus(file) || SchemaValidatingBuilderTest.ignore(file) || file.isDirectory()) {
                        System.out.println("\n" + k + ": IGNORING " + file + " ...");
                    } else if (file.getAbsolutePath().indexOf("-II-") < 0) {
                        System.out.println("\n" + k + ": now processing " + file + " ...");
                        int p = 0;
                        while (p < 1) {
                            Document doc1 = SchemaValidatingBuilderTest.getW3CBuilder().build(file);
                            Document doc2 = pooledBuilder.build(file);
                            IOTestUtil.xomAssertEquals(doc1, doc2);
                            IOTestUtil.canonicalAssertEquals(doc1, doc2);
                            ++p;
                        }
                    }
                    ++j;
                    ++k;
                }
                ++q;
            }
            ++i;
        }
    }

    private static Builder getW3CBuilder() {
        return new BuilderFactory().createW3CBuilder(null);
    }

    private static boolean ignore(File file) {
        return false;
    }
}

