/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLOutputFactory;
import nu.xom.Document;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingSerializerFactory;
import nux.xom.sandbox.IOTest;
import nux.xom.sandbox.IOTestUtil;

public class StaxSerializerTest
extends IOTest {
    public static void main(String[] args) throws Throwable {
        String[] encodings = new String[]{"UTF-8", "UTF-16", "UTF-16BE", "UTF-16LE"};
        System.setProperty("nu.xom.Verifier.checkURI", "false");
        XMLOutputFactory outFactory = StaxSerializerTest.createXMLOutputFactory(args[0]);
        StreamingSerializerFactory factory = new StreamingSerializerFactory();
        int bugs = 0;
        int k = 0;
        for (int i = 1; i < args.length; ++i) {
            File[] files = IOTestUtil.listXMLFiles(args[i]);
            int j = 0;
            while (j < files.length) {
                File file = files[j];
                if (StaxSerializerTest.bogus(file) || StaxSerializerTest.ignore(file) || file.isDirectory()) {
                    System.out.println("\n" + k + ": IGNORING " + file + " ...");
                } else {
                    System.out.println("\n" + k + ": now processing " + file + " ...");
                    Document expected = StaxSerializerTest.getBuilder().build(file);
                    System.out.print("*");
                    for (int enc = 0; enc < encodings.length; ++enc) {
                        try {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            StreamingSerializer ser = factory.createStaxSerializer(outFactory.createXMLStreamWriter(out, encodings[enc]));
                            ser.write(expected);
                            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                            Document actual = StaxSerializerTest.getBuilder().build((InputStream)in, file.toURI().toASCIIString());
                            IOTestUtil.xomAssertEquals(expected, actual);
                            IOTestUtil.canonicalAssertEquals(expected, actual);
                            continue;
                        }
                        catch (Throwable e) {
                            ++bugs;
                            if (FAIL_FAST) {
                                throw e;
                            }
                            System.err.println("\nOopsla:" + k + ":" + bugs + ":" + file + ":" + encodings[enc] + ":");
                            e.printStackTrace();
                        }
                    }
                }
                ++j;
                ++k;
            }
        }
        System.out.println("\nNumber of bugs detected: " + bugs);
    }

    private static XMLOutputFactory createXMLOutputFactory(String staxMode) {
        if (staxMode.equals("sun")) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.stream.ZephyrWriterFactory");
        } else if (staxMode.equals("wood")) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        System.out.println("outFactory=" + factory.getClass().getName());
        return factory;
    }

    private static void log(byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream("/tmp/test.xml");
        os.write(bytes);
        os.flush();
        os.close();
    }

    private static boolean ignore(File xmlFile) {
        String file = xmlFile.getAbsolutePath();
        return false;
    }
}

