/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.tests;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import nu.xom.Builder;
import nu.xom.NodeFactory;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingSerializerFactory;
import nux.xom.pool.XOMUtil;

public final class BinaryXMLConverter {
    private BinaryXMLConverter() {
    }

    public static void main(String[] args) throws Exception {
        int compressionLevel = Integer.getInteger("nux.xom.tests.BinaryXMLConverter.compressionLevel", 0);
        int runs = Integer.getInteger("nux.xom.tests.BinaryXMLConverter.runs", 1);
        boolean readOnly = Boolean.getBoolean("nux.xom.tests.BinaryXMLConverter.readOnly");
        StreamingSerializerFactory factory = new StreamingSerializerFactory();
        BinaryXMLCodec codec = new BinaryXMLCodec();
        if (args.length == 0) {
            BufferedInputStream in = new BufferedInputStream(System.in);
            if (codec.isBnuxDocument(in)) {
                StreamingSerializer ser = factory.createXMLSerializer(System.out, "UTF-8");
                NodeFactory redirector = XOMUtil.getRedirectingNodeFactory(ser);
                codec.deserialize(in, redirector);
            } else {
                StreamingSerializer ser = factory.createBinaryXMLSerializer(System.out, compressionLevel);
                NodeFactory redirector = XOMUtil.getRedirectingNodeFactory(ser);
                new Builder(redirector).build((InputStream)in);
            }
            return;
        }
        int run = 0;
        while (run < runs) {
            long s = System.currentTimeMillis();
            int i = 0;
            while (i < args.length) {
                String fileName = args[i];
                File file = new File(fileName);
                if (!file.isDirectory()) {
                    long start;
                    StreamingSerializer ser;
                    String destFileName;
                    NodeFactory redirector;
                    System.out.print(String.valueOf(fileName) + " --> ");
                    FileInputStream in = new FileInputStream(file);
                    FileOutputStream out = null;
                    if (fileName.endsWith(".bnux")) {
                        redirector = null;
                        if (readOnly) {
                            redirector = XOMUtil.getNullNodeFactory();
                        } else {
                            destFileName = fileName.substring(0, fileName.length() - ".bnux".length());
                            System.out.print(destFileName);
                            out = new FileOutputStream(destFileName);
                            ser = factory.createXMLSerializer(out, "UTF-8");
                            redirector = XOMUtil.getRedirectingNodeFactory(ser);
                        }
                        start = System.currentTimeMillis();
                        codec.deserialize(in, redirector);
                    } else {
                        redirector = null;
                        if (readOnly) {
                            redirector = XOMUtil.getNullNodeFactory();
                        } else {
                            destFileName = String.valueOf(fileName) + ".bnux";
                            System.out.print(destFileName);
                            out = new FileOutputStream(destFileName);
                            ser = codec.createStreamingSerializer(out, compressionLevel);
                            redirector = XOMUtil.getRedirectingNodeFactory(ser);
                        }
                        start = System.currentTimeMillis();
                        new Builder(redirector).build(file);
                    }
                    long end = System.currentTimeMillis();
                    System.out.println(" [ms=" + (end - start) + "]. ");
                    ((InputStream)in).close();
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                ++i;
            }
            long e = System.currentTimeMillis();
            System.out.println("Completed run=" + run + " [ms=" + (e - s) + "].");
            System.out.println("\n");
            ++run;
        }
    }
}

