/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.CacheStatistics;
import org.teiid.adminapi.EngineStatistics;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.WorkerPoolStatistics;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EngineStatisticsMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.PropertyDefinitionMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.deployers.ExtendedPropertyMetadataList;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.VDBResources;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.services.BufferServiceImpl;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorProperty;

public class EmbeddedAdminFactory {
    private static EmbeddedAdminFactory INSTANCE = new EmbeddedAdminFactory();

    private EmbeddedAdminFactory() {
    }

    public static EmbeddedAdminFactory getInstance() {
        return INSTANCE;
    }

    public static EngineStatisticsMetadata createEngineStats(int activeSessionsCount, BufferServiceImpl bufferService, DQPCore dqp) {
        EngineStatisticsMetadata stats = new EngineStatisticsMetadata();
        stats.setSessionCount(activeSessionsCount);
        stats.setTotalMemoryUsedInKB(bufferService.getHeapCacheMemoryInUseKB());
        stats.setMemoryUsedByActivePlansInKB(bufferService.getHeapMemoryInUseByActivePlansKB());
        stats.setDiskWriteCount(bufferService.getDiskWriteCount());
        stats.setDiskReadCount(bufferService.getDiskReadCount());
        stats.setCacheReadCount(bufferService.getCacheReadCount());
        stats.setCacheWriteCount(bufferService.getCacheWriteCount());
        stats.setDiskSpaceUsedInMB(bufferService.getUsedDiskBufferSpaceMB());
        stats.setActivePlanCount(dqp.getActivePlanCount());
        stats.setWaitPlanCount(dqp.getWaitingPlanCount());
        stats.setMaxWaitPlanWaterMark(dqp.getMaxWaitingPlanWatermark());
        return stats;
    }

    Admin createAdmin(EmbeddedServer embeddedServer) {
        return new AdminImpl(embeddedServer);
    }

    private static class AdminImpl
    implements Admin {
        private EmbeddedServer embeddedServer;

        public AdminImpl(EmbeddedServer embeddedServer) {
            this.embeddedServer = embeddedServer;
        }

        public void assignToModel(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40130, new Object[]{"assignToModel"}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSource(String vdbName, int vdbVersion, String modelName, String sourceName) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                ModelMetaData model = vdb.getModel(modelName);
                if (model == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, new Object[]{modelName, vdb.getName(), vdb.getVersion()}));
                }
                SourceMappingMetadata source = model.getSourceMapping(sourceName);
                if (source == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40107, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40107, new Object[]{sourceName, modelName, vdb.getName(), vdb.getVersion()}));
                }
                source = (SourceMappingMetadata)model.getSources().remove(sourceName);
                if (source == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, new Object[]{sourceName, modelName, vdb.getName(), vdb.getVersion()}));
                }
            }
        }

        private VDBMetaData checkVDB(String vdbName) throws AdminProcessingException {
            VDBMetaData vdb = this.embeddedServer.repo.getLiveVDB(vdbName);
            return vdb;
        }

        private VDBMetaData checkVDB(String vdbName, int vdbVersion) throws AdminProcessingException {
            VDBMetaData vdb = this.embeddedServer.repo.getLiveVDB(vdbName, vdbVersion);
            if (vdb == null) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40131, new Object[]{vdbName, vdbVersion}));
            }
            VDB.Status status = vdb.getStatus();
            if (status != VDB.Status.ACTIVE) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40132, new Object[]{vdbName, vdbVersion, status}));
            }
            return vdb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSource(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                ModelMetaData model = vdb.getModel(modelName);
                if (model == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, new Object[]{modelName, vdb.getName(), vdb.getVersion()}));
                }
                if (!model.isSupportsMultiSourceBindings()) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40108, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40108, new Object[]{modelName, vdb.getName(), vdb.getVersion()}));
                }
                SourceMappingMetadata source = model.getSourceMapping(sourceName);
                if (source != null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40107, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40107, new Object[]{sourceName, modelName, vdb.getName(), vdb.getVersion()}));
                }
                SourceMappingMetadata mapping = new SourceMappingMetadata(sourceName, translatorName, dsName);
                model.addSourceMapping(mapping);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSource(String vdbName, int vdbVersion, String sourceName, String translatorName, String dsName) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                for (ModelMetaData m : vdb.getModelMetaDatas().values()) {
                    SourceMappingMetadata mapping = m.getSourceMapping(sourceName);
                    if (mapping == null) continue;
                    mapping.setTranslatorName(translatorName);
                    mapping.setConnectionJndiName(dsName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeVDBConnectionType(String vdbName, int vdbVersion, VDB.ConnectionType type) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                vdb.setConnectionType(type);
            }
        }

        public void deploy(String deployName, InputStream content) throws AdminException {
            if (!deployName.endsWith("-vdb.xml")) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40142, new Object[]{deployName}));
            }
            try {
                this.embeddedServer.deployVDB(content);
            }
            catch (Exception e) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40133, new Object[]{deployName, e}), (Throwable)e);
            }
        }

        public void undeploy(String deployedName) throws AdminException {
            VDBMetaData vdb = this.checkVDB(deployedName);
            if (null == vdb) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40134, new Object[]{deployedName}));
            }
            this.embeddedServer.undeployVDB(deployedName);
        }

        public Collection<? extends VDB> getVDBs() throws AdminException {
            ArrayList<VDBMetaData> list = new ArrayList<VDBMetaData>();
            list.addAll(this.embeddedServer.repo.getVDBs());
            return list;
        }

        public VDB getVDB(String vdbName, int vdbVersion) throws AdminException {
            return this.embeddedServer.repo.getVDB(vdbName, vdbVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restartVDB(String vdbName, int vdbVersion, String ... models) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                try {
                    VDBMetaData currentVdb = this.embeddedServer.repo.removeVDB(vdbName, vdbVersion);
                    ConnectorManagerRepository cmr = this.embeddedServer.cmr;
                    UDFMetaData udf = (UDFMetaData)currentVdb.getAttachment(UDFMetaData.class);
                    LinkedHashMap<String, VDBResources.Resource> visibilityMap = new LinkedHashMap<String, VDBResources.Resource>();
                    MetadataStore store = new MetadataStore();
                    this.embeddedServer.repo.addVDB(currentVdb, store, visibilityMap, udf, cmr);
                }
                catch (Exception e) {
                    throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40135, new Object[]{vdbName, vdbVersion, models}), (Throwable)e);
                }
            }
        }

        public Collection<? extends Translator> getTranslators() throws AdminException {
            ArrayList<VDBTranslatorMetaData> list = new ArrayList<VDBTranslatorMetaData>();
            for (ExecutionFactory<?, ?> ef : this.embeddedServer.getTranslators().values()) {
                list.add(TranslatorUtil.buildTranslatorMetadata(ef, null));
            }
            return list;
        }

        public Translator getTranslator(String deployedName) throws AdminException {
            try {
                ExecutionFactory<Object, Object> ef = this.embeddedServer.getExecutionFactory(deployedName);
                VDBTranslatorMetaData metadata = TranslatorUtil.buildTranslatorMetadata(ef, null);
                return metadata;
            }
            catch (ConnectorManagerRepository.ConnectorManagerException e) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40136, new Object[]{deployedName, e}));
            }
        }

        public Collection<? extends WorkerPoolStatistics> getWorkerPoolStats() throws AdminException {
            return Arrays.asList(this.embeddedServer.dqp.getWorkerPoolStatistics());
        }

        public Collection<String> getCacheTypes() throws AdminException {
            HashSet<String> cacheTypes = new HashSet<String>();
            cacheTypes.addAll(SessionAwareCache.getCacheTypes());
            return cacheTypes;
        }

        public Collection<? extends Session> getSessions() throws AdminException {
            ArrayList<SessionMetadata> list = new ArrayList<SessionMetadata>();
            list.addAll(this.embeddedServer.sessionService.getActiveSessions());
            return list;
        }

        public Collection<? extends Request> getRequests() throws AdminException {
            ArrayList list = new ArrayList();
            list.addAll(this.embeddedServer.dqp.getRequests());
            return list;
        }

        public Collection<? extends Request> getRequestsForSession(String sessionId) throws AdminException {
            ArrayList list = new ArrayList();
            list.addAll(this.embeddedServer.dqp.getRequestsForSession(sessionId));
            return list;
        }

        public Collection<? extends PropertyDefinition> getTemplatePropertyDefinitions(String templateName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"getTemplatePropertyDefinitions"}));
        }

        public Collection<? extends PropertyDefinition> getTranslatorPropertyDefinitions(String translatorName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40130, new Object[]{"getTranslatorPropertyDefinitions"}));
        }

        public Collection<? extends PropertyDefinition> getTranslatorPropertyDefinitions(String translatorName, Admin.TranlatorPropertyType type) throws AdminException {
            ArrayList<PropertyDefinitionMetadata> list = new ArrayList<PropertyDefinitionMetadata>();
            try {
                ExecutionFactory<Object, Object> ef = this.embeddedServer.getExecutionFactory(translatorName);
                if (ef == null) {
                    return null;
                }
                VDBTranslatorMetaData translator = TranslatorUtil.buildTranslatorMetadata(ef, null);
                Admin.TranlatorPropertyType translatorPropertyType = Admin.TranlatorPropertyType.valueOf((String)type.toString().toUpperCase());
                if (translator != null) {
                    ExtendedPropertyMetadataList properties = (ExtendedPropertyMetadataList)translator.getAttachment(ExtendedPropertyMetadataList.class);
                    if (translatorPropertyType.equals((Object)Admin.TranlatorPropertyType.ALL)) {
                        for (ExtendedPropertyMetadata epm : properties) {
                            list.add(this.buildNode(epm));
                        }
                    } else {
                        TranslatorProperty.PropertyType propType = TranslatorProperty.PropertyType.valueOf((String)type.toString().toUpperCase());
                        for (ExtendedPropertyMetadata epm : properties) {
                            if (!TranslatorProperty.PropertyType.valueOf((String)epm.category()).equals((Object)propType)) continue;
                            list.add(this.buildNode(epm));
                        }
                    }
                }
            }
            catch (ConnectorManagerRepository.ConnectorManagerException e) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40138, new Object[]{translatorName, type, e}));
            }
            return list;
        }

        private PropertyDefinitionMetadata buildNode(ExtendedPropertyMetadata epm) {
            PropertyDefinitionMetadata pdm = new PropertyDefinitionMetadata();
            pdm.setAdvanced(epm.advanced());
            pdm.setAllowedValues(Arrays.asList(epm.allowed()));
            pdm.setDefaultValue((Serializable)((Object)epm.defaultValue()));
            pdm.setDescription(epm.description());
            pdm.setDisplayName(epm.display());
            pdm.setMasked(epm.masked());
            pdm.setName(epm.name());
            pdm.setPropertyTypeClassName(epm.datatype());
            if (epm.readOnly()) {
                pdm.setModifiable(false);
            } else {
                pdm.setModifiable(true);
            }
            pdm.setRequired(epm.required());
            pdm.setCategory(epm.category());
            return pdm;
        }

        public Collection<? extends Transaction> getTransactions() throws AdminException {
            return this.embeddedServer.dqp.getTransactions();
        }

        public void clearCache(String cacheType) throws AdminException {
            if (cacheType.equals(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.name())) {
                this.embeddedServer.getRsCache().clearAll();
            } else if (cacheType.equals(Admin.Cache.PREPARED_PLAN_CACHE.name())) {
                this.embeddedServer.getPpcCache().clearAll();
            } else {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40139, new Object[]{cacheType, Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE, Admin.Cache.PREPARED_PLAN_CACHE}));
            }
        }

        public void clearCache(String cacheType, String vdbName, int vdbVersion) throws AdminException {
            this.checkVDB(vdbName, vdbVersion);
            if (cacheType.equals(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.name())) {
                this.embeddedServer.getRsCache().clearForVDB(vdbName, vdbVersion);
            } else if (cacheType.equals(Admin.Cache.PREPARED_PLAN_CACHE.name())) {
                this.embeddedServer.getPpcCache().clearForVDB(vdbName, vdbVersion);
            } else {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40139, new Object[]{cacheType, Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE, Admin.Cache.PREPARED_PLAN_CACHE}));
            }
        }

        public Collection<? extends CacheStatistics> getCacheStats(String cacheType) throws AdminException {
            if (cacheType.equals(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.name())) {
                return Arrays.asList(this.embeddedServer.getRsCache().buildCacheStats(cacheType));
            }
            if (cacheType.equals(Admin.Cache.PREPARED_PLAN_CACHE.name())) {
                return Arrays.asList(this.embeddedServer.getPpcCache().buildCacheStats(cacheType));
            }
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40139, new Object[]{cacheType, Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE, Admin.Cache.PREPARED_PLAN_CACHE}));
        }

        public Collection<? extends EngineStatistics> getEngineStats() throws AdminException {
            try {
                EngineStatisticsMetadata stats = EmbeddedAdminFactory.createEngineStats(this.embeddedServer.sessionService.getActiveSessionsCount(), this.embeddedServer.bufferService, this.embeddedServer.dqp);
                return Arrays.asList(stats);
            }
            catch (SessionServiceException e) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40140, new Object[]{"getEngineStats", e}));
            }
        }

        public void terminateSession(String sessionId) throws AdminException {
            this.embeddedServer.sessionService.terminateSession(sessionId, DQPWorkContext.getWorkContext().getSessionId());
        }

        public void cancelRequest(String sessionId, long executionId) throws AdminException {
            try {
                this.embeddedServer.dqp.cancelRequest(sessionId, executionId);
            }
            catch (TeiidComponentException e) {
                throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40141, new Object[]{sessionId, executionId, e}));
            }
        }

        public void terminateTransaction(String transactionId) throws AdminException {
            this.embeddedServer.dqp.terminateTransaction(transactionId);
        }

        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataRoleMapping(String vdbName, int vdbVersion, String dataRole, String mappedRoleName) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                DataPolicyMetadata policy = this.getPolicy(vdb, dataRole);
                policy.addMappedRoleName(mappedRoleName);
            }
        }

        private DataPolicyMetadata getPolicy(VDBMetaData vdb, String policyName) throws AdminProcessingException {
            DataPolicyMetadata policy = (DataPolicyMetadata)vdb.getDataPolicyMap().get(policyName);
            if (policy == null) {
                throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40092, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40092, new Object[]{policyName, vdb.getName(), vdb.getVersion()}));
            }
            return policy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDataRoleMapping(String vdbName, int vdbVersion, String dataRole, String mappedRoleName) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                DataPolicyMetadata policy = this.getPolicy(vdb, dataRole);
                policy.removeMappedRoleName(mappedRoleName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAnyAuthenticatedForDataRole(String vdbName, int vdbVersion, String dataRole, boolean anyAuthenticated) throws AdminException {
            VDBMetaData vdb;
            VDBMetaData vDBMetaData = vdb = this.checkVDB(vdbName, vdbVersion);
            synchronized (vDBMetaData) {
                DataPolicyMetadata policy = this.getPolicy(vdb, dataRole);
                policy.setAnyAuthenticated(anyAuthenticated);
            }
        }

        public void createDataSource(String deploymentName, String templateName, Properties properties) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"createDataSource"}));
        }

        public Properties getDataSource(String deployedName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"getDataSource"}));
        }

        public void deleteDataSource(String deployedName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"deleteDataSource"}));
        }

        public Collection<String> getDataSourceNames() throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"getDataSourceNames"}));
        }

        public Set<String> getDataSourceTemplateNames() throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"getDataSourceTemplateNames"}));
        }

        public void markDataSourceAvailable(String jndiName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"markDataSourceAvailable"}));
        }

        public String getSchema(String vdbName, int vdbVersion, String modelName, EnumSet<Admin.SchemaObjectType> allowedTypes, String typeNamePattern) throws AdminException {
            VDBMetaData vdb = this.checkVDB(vdbName, vdbVersion);
            CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
            Schema schema = metadataStore.getSchema(modelName);
            String ddl = DDLStringVisitor.getDDLString((Schema)schema, allowedTypes, (String)typeNamePattern);
            return ddl;
        }

        public String getQueryPlan(String sessionId, int executionId) throws AdminException {
            PlanNode plan = this.embeddedServer.dqp.getPlan(sessionId, (long)executionId);
            if (plan == null) {
                return null;
            }
            return plan.toXml();
        }

        public void restart() {
            throw new RuntimeException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"restart"}));
        }
    }
}

