/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.converter;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public enum PrimitiveType {
    INT((Type)((Object)Integer.class), "int", "integer"),
    LONG((Type)((Object)Long.class), "long", new String[0]),
    FLOAT((Type)((Object)Float.class), "float", new String[0]),
    DOUBLE((Type)((Object)Double.class), "double", new String[0]),
    STRING((Type)((Object)String.class), "string", new String[0]),
    BYTE((Type)((Object)Byte.class), "byte", new String[0]),
    BOOLEAN((Type)((Object)Boolean.class), "boolean", new String[0]),
    URI((Type)((Object)URI.class), "uri", new String[0]),
    URL((Type)((Object)URL.class), "url", new String[0]),
    UUID((Type)((Object)UUID.class), "uuid", new String[0]),
    DATE_TIME((Type)((Object)Date.class), "dateTime", new String[0]);

    private final Type type;
    private final Set<String> names;

    private PrimitiveType(Type type, String name, String ... aliases) {
        this.type = type;
        HashSet<String> tmpNames = new HashSet<String>();
        tmpNames.add(name.toUpperCase());
        for (String item : aliases) {
            tmpNames.add(item.toUpperCase());
        }
        this.names = Collections.unmodifiableSet(tmpNames);
    }

    public static PrimitiveType fromName(String name) {
        if (name != null) {
            String key = name.toUpperCase();
            for (PrimitiveType item : PrimitiveType.values()) {
                if (!item.names.contains(key)) continue;
                return item;
            }
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }
}

