/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jboss.rest.RestASMBasedWebArchiveBuilder;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestRestWebArchiveBuilder {
    @Test
    public void testBuildArchive() throws Exception {
        ZipEntry ze;
        VDBMetaData vdb = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"sample-vdb.xml")));
        MetadataStore ms = new MetadataStore();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            MetadataFactory mf = this.buildMetadataFactory(model.getSchemaText(), model.getName());
            ms.addSchema(mf.getSchema());
        }
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)ms, (String)"Rest", (FunctionTree[])new FunctionTree[0]);
        vdb.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        vdb.addAttchment(TransformationMetadata.class, (Object)metadata);
        vdb.addAttchment(MetadataStore.class, (Object)ms);
        RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
        byte[] contents = builder.createRestArchive(vdb);
        ArrayList<String> files = new ArrayList<String>();
        files.add("WEB-INF/web.xml");
        files.add("WEB-INF/jboss-web.xml");
        files.add("WEB-INF/classes/org/teiid/jboss/rest/View.class");
        files.add("WEB-INF/classes/org/teiid/jboss/rest/TeiidRestApplication.class");
        files.add("META-INF/MANIFEST.MF");
        ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(contents));
        while ((ze = zipIn.getNextEntry()) != null) {
            Assert.assertTrue((boolean)files.contains(ze.getName()));
            zipIn.closeEntry();
        }
    }

    public MetadataFactory buildMetadataFactory(String ddl, String model) throws ParseException {
        MetadataFactory mf = new MetadataFactory(null, 1, model, TestRestWebArchiveBuilder.getDataTypes(), new Properties(), null);
        new QueryParser().parseDDL(mf, ddl);
        return mf;
    }

    static Map<String, Datatype> getDataTypes() {
        return SystemMetadata.getInstance().getRuntimeTypeMap();
    }
}

