/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.VDBOperations;

class RestartVDB
extends VDBOperations {
    public RestartVDB() {
        super("restart-vdb");
    }

    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        ArrayList<String> models = new ArrayList<String>();
        if (operation.hasDefined("model-names")) {
            String modelNames = operation.get("model-names").asString();
            for (String model : modelNames.split(",")) {
                models.add(model.trim());
            }
        }
        try {
            vdb.restart(models);
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        super.describeParameters(operationNode, bundle);
        operationNode.get(new String[]{"request-properties", "model-names", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "model-names", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "model-names", "description"}).set(this.getParameterDescription(bundle, "model-names"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

