/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.teiid.jboss.Element;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidAdd;
import org.teiid.jboss.TranslatorAdd;
import org.teiid.jboss.TransportAdd;

public class TeiidSubsystemDescribe
implements OperationStepHandler,
DescriptionProvider {
    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("describe");
        node.get("description").set(bundle.getString("teiid_subsystem.describe"));
        node.get("reply-properties").get("type").set(ModelType.LIST);
        TeiidAdd.describeTeiid(node.get("reply-properties"), "value-type", bundle);
        return node;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode addOperation;
        ModelNode address;
        ModelNode result = context.getResult();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        TeiidAdd.populate(subModel, subsystemAdd);
        result.add(subsystemAdd);
        if (subModel.hasDefined(Element.TRANSPORT_ELEMENT.getLocalName())) {
            for (Property container : subModel.get(Element.TRANSPORT_ELEMENT.getLocalName()).asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add(Element.TRANSPORT_ELEMENT.getLocalName(), container.getName());
                addOperation = new ModelNode();
                addOperation.get("operation").set("add");
                addOperation.get("address").set(address);
                TransportAdd.populate(container.getValue(), addOperation);
                result.add(addOperation);
            }
        }
        if (subModel.hasDefined(Element.TRANSLATOR_ELEMENT.getLocalName())) {
            for (Property container : subModel.get(Element.TRANSLATOR_ELEMENT.getLocalName()).asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add(Element.TRANSLATOR_ELEMENT.getLocalName(), container.getName());
                addOperation = new ModelNode();
                addOperation.get("operation").set("add");
                addOperation.get("address").set(address);
                TranslatorAdd.populate(container.getValue(), addOperation);
                result.add(addOperation);
            }
        }
        context.completeStep();
    }
}

