/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptEngineManager;
import org.jboss.as.controller.ModelController;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidAttachments;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.VDBService;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.metadata.index.IndexMetadataStore;
import org.teiid.query.ObjectReplicator;
import org.teiid.vdb.runtime.VDBKey;

class VDBDeployer
implements DeploymentUnitProcessor {
    private static final String JAVA_CONTEXT = "java:/";
    private TranslatorRepository translatorRepository;
    private String asyncThreadPoolName;
    private VDBStatusChecker vdbStatusChecker;
    JBossLifeCycleListener shutdownListener;

    public VDBDeployer(TranslatorRepository translatorRepo, String poolName, VDBStatusChecker vdbStatusChecker, JBossLifeCycleListener shutdownListener) {
        this.translatorRepository = translatorRepo;
        this.asyncThreadPoolName = poolName;
        this.vdbStatusChecker = vdbStatusChecker;
        this.shutdownListener = shutdownListener;
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        boolean preview;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        final VDBMetaData deployment = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
        deployment.addProperty("deployment-name", deploymentUnit.getName());
        ServiceController controller = context.getServiceRegistry().getService(TeiidServiceNames.vdbServiceName(deployment.getName(), deployment.getVersion()));
        if (controller != null) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50019, new Object[]{deployment}));
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        if (!(preview = deployment.isPreview()) && deployment.hasErrors()) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50074, new Object[]{deployment}));
        }
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            if (!model.isSource() || model.getSourceNames().isEmpty()) continue;
            for (String source : model.getSourceNames()) {
                VDBTranslatorMetaData translator;
                String translatorName = model.getSourceTranslatorName(source);
                if (deployment.isOverideTranslator(translatorName)) {
                    VDBTranslatorMetaData parent = deployment.getTranslator(translatorName);
                    translatorName = parent.getType();
                }
                if ((translator = this.translatorRepository.getTranslatorMetaData(translatorName)) != null) continue;
                String msg = IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50077, new Object[]{translatorName, deployment.getName(), deployment.getVersion()});
                LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)msg);
            }
        }
        ModuleClassLoader classLoader = ((Module)deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        deployment.addAttchment(ClassLoader.class, (Object)classLoader);
        deployment.addAttchment(ScriptEngineManager.class, (Object)new ScriptEngineManager((ClassLoader)classLoader));
        UDFMetaData udf = (UDFMetaData)deploymentUnit.removeAttachment(TeiidAttachments.UDF_METADATA);
        if (udf != null) {
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            if (module != null) {
                udf.setFunctionClassLoader((ClassLoader)module.getClassLoader());
            }
            deployment.addAttchment(UDFMetaData.class, (Object)udf);
        }
        IndexMetadataRepository indexRepo = null;
        IndexMetadataStore indexFactory = (IndexMetadataStore)deploymentUnit.removeAttachment(TeiidAttachments.INDEX_METADATA);
        LinkedHashMap visibilityMap = null;
        if (indexFactory != null) {
            indexRepo = new IndexMetadataRepository(indexFactory);
            visibilityMap = indexFactory.getEntriesPlusVisibilities();
        }
        VDBRepository repo = this.vdbStatusChecker.getVDBRepository();
        repo.addPendingDeployment(deployment);
        VDBService vdb = new VDBService(deployment, visibilityMap);
        if (indexRepo != null) {
            vdb.addMetadataRepository("index", (MetadataRepository)indexRepo);
        }
        ServiceBuilder vdbService = context.getServiceTarget().addService(TeiidServiceNames.vdbServiceName(deployment.getName(), deployment.getVersion()), (Service)vdb);
        this.dataSourceDependencies(deployment, context.getServiceTarget());
        for (VDBImportMetadata vdbImport : deployment.getVDBImports()) {
            vdbService.addDependency(TeiidServiceNames.vdbFinishedServiceName(vdbImport.getName(), vdbImport.getVersion()));
        }
        for (Model model : deployment.getModels()) {
            List sourceNames = model.getSourceNames();
            for (String sourceName : sourceNames) {
                String translatorName = model.getSourceTranslatorName(sourceName);
                if (deployment.isOverideTranslator(translatorName)) {
                    VDBTranslatorMetaData translator = deployment.getTranslator(translatorName);
                    translatorName = translator.getType();
                }
                vdbService.addDependency(TeiidServiceNames.translatorServiceName(translatorName));
            }
        }
        ServiceName vdbSwitchServiceName = TeiidServiceNames.vdbSwitchServiceName(deployment.getName(), deployment.getVersion());
        vdbService.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, vdb.vdbRepositoryInjector);
        vdbService.addDependency(TeiidServiceNames.TRANSLATOR_REPO, TranslatorRepository.class, vdb.translatorRepositoryInjector);
        vdbService.addDependency(TeiidServiceNames.executorServiceName(this.asyncThreadPoolName), Executor.class, vdb.executorInjector);
        vdbService.addDependency(TeiidServiceNames.OBJECT_SERIALIZER, ObjectSerializer.class, vdb.serializerInjector);
        vdbService.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, vdb.bufferManagerInjector);
        vdbService.addDependency(TeiidServiceNames.VDB_STATUS_CHECKER, VDBStatusChecker.class, vdb.vdbStatusCheckInjector);
        vdbService.addDependency(vdbSwitchServiceName, CountDownLatch.class, (Injector)new InjectedValue());
        vdbService.addDependency(ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, vdb.objectReplicatorInjector);
        vdbService.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, vdb.controllerValue);
        this.installVDBSwitchService(context.getServiceTarget(), vdbSwitchServiceName);
        vdbService.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController controller, ServiceController.Transition transition) {
                RuntimeVDB runtimeVDB;
                if (transition.equals((Object)ServiceController.Transition.DOWN_to_WAITING) && (runtimeVDB = (RuntimeVDB)RuntimeVDB.class.cast(controller.getValue())) != null && runtimeVDB.isRestartInProgress()) {
                    ServiceName vdbSwitchServiceName = TeiidServiceNames.vdbSwitchServiceName(deployment.getName(), deployment.getVersion());
                    ServiceController switchSvc = controller.getServiceContainer().getService(vdbSwitchServiceName);
                    if (switchSvc != null) {
                        CountDownLatch latch = (CountDownLatch)CountDownLatch.class.cast(switchSvc.getValue());
                        try {
                            latch.await(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    VDBDeployer.this.installVDBSwitchService((ServiceTarget)controller.getServiceContainer(), vdbSwitchServiceName);
                }
            }
        });
        vdbService.setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private void installVDBSwitchService(ServiceTarget serviceTarget, ServiceName vdbSwitchServiceName) {
        ServiceBuilder svc = serviceTarget.addService(vdbSwitchServiceName, (Service)new Service<CountDownLatch>(){
            private CountDownLatch latch = new CountDownLatch(1);

            public CountDownLatch getValue() throws IllegalStateException, IllegalArgumentException {
                return this.latch;
            }

            public void start(StartContext context) throws StartException {
            }

            public void stop(StopContext context) {
            }
        });
        svc.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController controller, ServiceController.Transition transition) {
                if (transition.equals((Object)ServiceController.Transition.REMOVING_to_REMOVED)) {
                    CountDownLatch latch = (CountDownLatch)CountDownLatch.class.cast(controller.getValue());
                    latch.countDown();
                }
            }
        });
        svc.install();
    }

    static void addDataSourceListener(ServiceTarget serviceTarget, VDBKey vdbKey, String dsName, VDBStatusChecker vdbStatusChecker) {
        String jndiName = VDBDeployer.getJndiName(dsName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        ServiceName svcName = bindInfo.getBinderServiceName();
        DataSourceListener dsl = new DataSourceListener(dsName, svcName, vdbStatusChecker, vdbKey);
        ServiceBuilder sb = serviceTarget.addService(TeiidServiceNames.dsListenerServiceName(vdbKey.getName(), vdbKey.getVersion(), dsName), (Service)dsl);
        sb.addDependency(svcName);
        sb.setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private void dataSourceDependencies(VDBMetaData deployment, ServiceTarget serviceTarget) {
        VDBKey vdbKey = new VDBKey(deployment.getName(), deployment.getVersion());
        HashSet<String> dataSources = new HashSet<String>();
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            for (String sourceName : model.getSourceNames()) {
                String dsName;
                String translatorName = model.getSourceTranslatorName(sourceName);
                if (deployment.isOverideTranslator(translatorName)) {
                    VDBTranslatorMetaData translator = deployment.getTranslator(translatorName);
                    translatorName = translator.getType();
                }
                if ((dsName = model.getSourceConnectionJndiName(sourceName)) == null || !dataSources.add(VDBStatusChecker.stripContext((String)dsName))) continue;
                VDBDeployer.addDataSourceListener(serviceTarget, vdbKey, dsName, this.vdbStatusChecker);
            }
        }
    }

    public static String getJndiName(String name) {
        String jndiName = name;
        if (!name.startsWith(JAVA_CONTEXT)) {
            jndiName = JAVA_CONTEXT + jndiName;
        }
        return jndiName;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        VDBMetaData deployment = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
        if (!this.shutdownListener.isShutdownInProgress()) {
            VDBMetaData vdb = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
            ServiceController sc = deploymentUnit.getServiceRegistry().getService(TeiidServiceNames.OBJECT_SERIALIZER);
            if (sc != null) {
                ObjectSerializer serilalizer = (ObjectSerializer)ObjectSerializer.class.cast(sc.getValue());
                serilalizer.removeAttachments(vdb);
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB " + vdb.getName() + " metadata removed"});
            }
        }
        this.vdbStatusChecker.getVDBRepository().removeVDB(deployment.getName(), deployment.getVersion());
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            for (SourceMappingMetadata smm : model.getSources().values()) {
                ServiceController dsService;
                String dsName = smm.getConnectionJndiName();
                if (dsName == null || (dsService = deploymentUnit.getServiceRegistry().getService(TeiidServiceNames.dsListenerServiceName(deployment.getName(), deployment.getVersion(), dsName))) == null) continue;
                dsService.setMode(ServiceController.Mode.REMOVE);
            }
        }
        ServiceController controller = deploymentUnit.getServiceRegistry().getService(TeiidServiceNames.vdbServiceName(deployment.getName(), deployment.getVersion()));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    static class DataSourceListener
    implements Service<DataSourceListener> {
        private VDBStatusChecker vdbStatusChecker;
        private String dsName;
        private ServiceName svcName;
        private VDBKey vdb;

        public DataSourceListener(String dsName, ServiceName svcName, VDBStatusChecker checker, VDBKey vdb) {
            this.dsName = dsName;
            this.svcName = svcName;
            this.vdbStatusChecker = checker;
            this.vdb = vdb;
        }

        public DataSourceListener getValue() throws IllegalStateException, IllegalArgumentException {
            return this;
        }

        public void start(StartContext context) throws StartException {
            ServiceController s = context.getController().getServiceContainer().getService(this.svcName);
            if (s != null) {
                this.vdbStatusChecker.dataSourceAdded(this.dsName, this.vdb);
            }
        }

        public void stop(StopContext context) {
            ServiceController s = context.getController().getServiceContainer().getService(this.svcName);
            if (s.getMode().equals((Object)ServiceController.Mode.REMOVE) || s.getState().equals((Object)ServiceController.State.STOPPING)) {
                this.vdbStatusChecker.dataSourceRemoved(this.dsName, this.vdb);
            }
        }
    }
}

