/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.LinkedHashMap;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.symbol.XMLSerialize;

public abstract class TeiidRSProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream execute(String vdbName, int version, String procedureSignature, LinkedHashMap<String, String> parameters, String charSet, boolean passthroughAuth) throws SQLException {
        Object result = null;
        if (charSet != null && charSet.trim().isEmpty()) {
            charSet = null;
        }
        Connection conn = this.getConnection(vdbName, version, passthroughAuth);
        boolean usingReturn = procedureSignature.startsWith("{ ?");
        try {
            boolean hasResultSet;
            CallableStatement statement = conn.prepareCall(procedureSignature);
            if (!parameters.isEmpty()) {
                int i = usingReturn ? 2 : 1;
                for (String value : parameters.values()) {
                    statement.setString(i++, value);
                }
            }
            if (hasResultSet = statement.execute()) {
                ResultSet rs = statement.getResultSet();
                if (!rs.next()) {
                    throw new SQLException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50092, new Object[0]));
                }
                result = rs.getObject(1);
                rs.close();
            } else {
                if (!usingReturn) {
                    throw new SQLException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50092, new Object[0]));
                }
                result = statement.getObject(1);
            }
            statement.close();
            InputStream inputStream = this.handleResult(charSet, result);
            return inputStream;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private InputStream handleResult(String charSet, Object result) throws SQLException {
        if (result == null) {
            return null;
        }
        if (result instanceof SQLXML) {
            if (charSet != null) {
                XMLSerialize serialize = new XMLSerialize();
                serialize.setTypeString("blob");
                serialize.setDeclaration(Boolean.valueOf(true));
                serialize.setEncoding(charSet);
                serialize.setDocument(Boolean.valueOf(true));
                try {
                    return ((BlobType)XMLSystemFunctions.serialize((XMLSerialize)serialize, (XMLType)new XMLType((SQLXML)result))).getBinaryStream();
                }
                catch (TransformationException e) {
                    throw new SQLException(e);
                }
            }
            return ((SQLXML)result).getBinaryStream();
        }
        if (result instanceof Blob) {
            return ((Blob)result).getBinaryStream();
        }
        if (result instanceof Clob) {
            return new ReaderInputStream(((Clob)result).getCharacterStream(), charSet == null ? Charset.defaultCharset() : Charset.forName(charSet));
        }
        return new ByteArrayInputStream(result.toString().getBytes(charSet == null ? Charset.defaultCharset() : Charset.forName(charSet)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream executeQuery(String vdbName, int vdbVersion, String sql, boolean json, boolean passthroughAuth) throws SQLException {
        Connection conn = this.getConnection(vdbName, vdbVersion, passthroughAuth);
        Object result = null;
        try {
            Statement statement = conn.createStatement();
            boolean hasResultSet = statement.execute(sql);
            if (hasResultSet) {
                ResultSet rs = statement.getResultSet();
                if (!rs.next()) {
                    throw new SQLException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50092, new Object[0]));
                }
                result = rs.getObject(1);
                rs.close();
            }
            statement.close();
            InputStream inputStream = this.handleResult(Charset.defaultCharset().name(), result);
            return inputStream;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private Connection getConnection(String vdbName, int version, boolean passthough) throws SQLException {
        TeiidDriver driver = new TeiidDriver();
        return driver.connect("jdbc:teiid:" + vdbName + "." + version + (passthough ? "PassthroughAuthentication=true" : ""), null);
    }
}

