/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import java.util.ResourceBundle;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;

class ReadRARDescription
extends TeiidOperationHandler {
    protected ReadRARDescription() {
        super("read-rar-description");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        if (!operation.hasDefined("rar-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("rar-name.missing")));
        }
        String rarName = operation.get("rar-name").asString();
        ServiceName svcName = ServiceName.JBOSS.append(new String[]{"deployment", "unit"}).append(new String[]{rarName});
        ServiceController sc = context.getServiceRegistry(false).getService(svcName);
        if (sc == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("RAR_notfound")));
        }
        DeploymentUnit du = (DeploymentUnit)DeploymentUnit.class.cast(sc.getValue());
        ConnectorXmlDescriptor cd = (ConnectorXmlDescriptor)du.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        ResourceAdapter ra = cd.getConnector().getResourceadapter();
        if (ra instanceof ResourceAdapter1516) {
            ResourceAdapter1516 ra1516 = (ResourceAdapter1516)ra;
            result.add(this.buildReadOnlyNode("resourceadapter-class", ra1516.getResourceadapterClass()));
            List connDefinitions = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
            for (ConnectionDefinition p : connDefinitions) {
                result.add(this.buildReadOnlyNode("managedconnectionfactory-class", p.getManagedConnectionFactoryClass().toString()));
                List props = p.getConfigProperties();
                for (ConfigProperty prop : props) {
                    result.add(this.buildNode(prop));
                }
            }
        }
    }

    private ModelNode buildReadOnlyNode(String name, String value) {
        ModelNode node = new ModelNode();
        node.get(new String[]{name, "type"}).set(ModelType.STRING);
        node.get(new String[]{name, "display"}).set(name);
        node.get(new String[]{name, "read-only"}).set(Boolean.toString(Boolean.TRUE));
        node.get(new String[]{name, "advanced"}).set(Boolean.toString(Boolean.TRUE));
        node.get(new String[]{name, "default"}).set(value);
        return node;
    }

    private ModelNode buildNode(ConfigProperty prop) {
        ModelNode node = new ModelNode();
        String name = prop.getConfigPropertyName().getValue();
        String type = prop.getConfigPropertyType().getValue();
        String defaltValue = null;
        if (prop.getConfigPropertyValue() != null) {
            defaltValue = prop.getConfigPropertyValue().getValue();
        }
        String description = null;
        if (prop.getDescriptions() != null) {
            description = ((LocalizedXsdString)prop.getDescriptions().get(0)).getValue();
        }
        ExtendedPropertyMetadata extended = new ExtendedPropertyMetadata(name, type, description, defaltValue);
        if ("java.lang.String".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.STRING);
        } else if ("java.lang.Integer".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.INT);
        } else if ("java.lang.Long".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.LONG);
        } else if ("java.lang.Boolean".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.BOOLEAN);
        }
        node.get(new String[]{name, "required"}).set(extended.required());
        if (extended.description() != null) {
            node.get(new String[]{name, "description"}).set(extended.description());
        }
        node.get(new String[]{name, "display"}).set(extended.display());
        node.get(new String[]{name, "read-only"}).set(extended.readOnly());
        node.get(new String[]{name, "advanced"}).set(extended.advanced());
        if (extended.allowed() != null) {
            for (String s : extended.allowed()) {
                node.get(new String[]{name, "allowed"}).add(s);
            }
        }
        node.get(new String[]{name, "masked"}).set(extended.masked());
        if (extended.defaultValue() != null) {
            node.get(new String[]{name, "default"}).set(extended.defaultValue());
        }
        return node;
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "rar-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "rar-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "rar-name", "description"}).set(this.getParameterDescription(bundle, "rar-name"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        reply.get("value-type").set(ModelType.STRING);
    }
}

