/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.ConcurrentMapInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.AttributeWrite;
import org.teiid.jboss.Element;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ReferenceFactoryService;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;

class TransportAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static Element[] attributes = new Element[]{Element.TRANSPORT_PROTOCOL_ATTRIBUTE, Element.TRANSPORT_SOCKET_BINDING_ATTRIBUTE, Element.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE, Element.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE, Element.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE, Element.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, Element.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, Element.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, Element.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE, Element.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT, Element.SSL_MODE_ATTRIBUTE, Element.SSL_AUTH_MODE_ATTRIBUTE, Element.SSL_SSL_PROTOCOL_ATTRIBUTE, Element.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE, Element.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE, Element.SSL_KETSTORE_NAME_ATTRIBUTE, Element.SSL_KETSTORE_PASSWORD_ATTRIBUTE, Element.SSL_KETSTORE_TYPE_ATTRIBUTE, Element.SSL_TRUSTSTORE_NAME_ATTRIBUTE, Element.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE, Element.SSL_KETSTORE_ALIAS_ATTRIBUTE};

    TransportAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set("transport.add");
        TransportAdd.describeTransport(node, "request-properties", bundle);
        return node;
    }

    static void describeTransport(ModelNode node, String type, ResourceBundle bundle) {
        TransportAdd.transportDescribe(node, type, bundle);
    }

    static void transportDescribe(ModelNode node, String type, ResourceBundle bundle) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].describe(node, type, bundle);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        TransportAdd.populate(operation, model);
    }

    public static void populate(ModelNode operation, ModelNode model) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].populate(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String transportName = pathAddress.getLastElement().getValue();
        TransportService transport = new TransportService(transportName);
        String socketBinding = null;
        if (Element.TRANSPORT_SOCKET_BINDING_ATTRIBUTE.isDefined(operation)) {
            socketBinding = Element.TRANSPORT_SOCKET_BINDING_ATTRIBUTE.asString(operation, context);
            transport.setSocketConfig(this.buildSocketConfiguration(context, operation));
        } else {
            transport.setEmbedded(true);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{IntegrationPlugin.Util.getString("socket_binding_not_defined", new Object[]{transportName})});
        }
        List<String> domainList = Collections.emptyList();
        if (Element.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE.isDefined(operation)) {
            String domains = Element.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE.asString(operation, context);
            domainList = Arrays.asList(domains.split(","));
        }
        transport.setAuthenticationDomains(domainList);
        if (Element.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE.isDefined(operation)) {
            transport.setSessionMaxLimit(Element.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE.asLong(operation, context));
        }
        if (Element.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE.isDefined(operation)) {
            transport.setSessionExpirationTimeLimit(Element.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE.asLong(operation, context));
        }
        if (Element.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE.isDefined(operation)) {
            transport.setAuthenticationType(AuthenticationType.GSS);
            transport.setKrb5Domain(Element.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE.asString(operation, context));
        } else {
            transport.setAuthenticationType(AuthenticationType.CLEARTEXT);
        }
        if (Element.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT.isDefined(operation)) {
            transport.setMaxODBCLobSizeAllowed(Element.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT.asInt(operation, context));
        }
        ServiceBuilder transportBuilder = target.addService(TeiidServiceNames.transportServiceName(transportName), (Service)transport);
        if (socketBinding != null) {
            transportBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"binding", socketBinding}), SocketBinding.class, transport.getSocketBindingInjector());
        }
        transportBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, transport.getBufferManagerInjector());
        transportBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, transport.getVdbRepositoryInjector());
        transportBuilder.addDependency(TeiidServiceNames.ENGINE, DQPCore.class, transport.getDqpInjector());
        for (String domain : domainList) {
            LogManager.logInfo((String)"org.teiid.SECURITY", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50011, new Object[]{domain, transportName}));
            transportBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"security", "security-domain", domain}), SecurityDomainContext.class, (Injector)new ConcurrentMapInjector(transport.securityDomains, (Object)domain));
        }
        transportBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(transportBuilder.install());
        if (transport.isEmbedded() && !this.isEmbeddedRegistered(transportName)) {
            ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
            ServiceName referenceFactoryServiceName = TeiidServiceNames.embeddedTransportServiceName(transportName).append(new String[]{"reference-factory"});
            ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
            referenceBuilder.addDependency(TeiidServiceNames.transportServiceName(transportName), ClientServiceRegistry.class, referenceFactoryService.getInjector());
            referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)LocalServerConnection.jndiNameForRuntime((String)transportName));
            BinderService binderService = new BinderService(bindInfo.getBindName());
            ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
            binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector());
            binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
            binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            newControllers.add(referenceBuilder.install());
            newControllers.add(binderBuilder.install());
        }
    }

    protected boolean isEmbeddedRegistered(String transportName) {
        try {
            InitialContext ic = new InitialContext();
            ic.lookup(LocalServerConnection.jndiNameForRuntime((String)transportName));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private SocketConfiguration buildSocketConfiguration(OperationContext context, ModelNode node) throws OperationFailedException {
        SocketConfiguration socket = new SocketConfiguration();
        if (Element.TRANSPORT_PROTOCOL_ATTRIBUTE.isDefined(node)) {
            socket.setProtocol(Element.TRANSPORT_PROTOCOL_ATTRIBUTE.asString(node, context));
        }
        if (Element.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE.isDefined(node)) {
            socket.setMaxSocketThreads(Element.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE.asInt(node, context));
        }
        if (Element.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE.isDefined(node)) {
            socket.setInputBufferSize(Element.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE.asInt(node, context));
        }
        if (Element.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE.isDefined(node)) {
            socket.setOutputBufferSize(Element.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE.asInt(node, context));
        }
        SSLConfiguration ssl = new SSLConfiguration();
        if (Element.SSL_MODE_ATTRIBUTE.isDefined(node)) {
            ssl.setMode(Element.SSL_MODE_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_SSL_PROTOCOL_ATTRIBUTE.isDefined(node)) {
            ssl.setSslProtocol(Element.SSL_SSL_PROTOCOL_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE.isDefined(node)) {
            ssl.setKeymanagementAlgorithm(Element.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_AUTH_MODE_ATTRIBUTE.isDefined(node)) {
            ssl.setAuthenticationMode(Element.SSL_AUTH_MODE_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_KETSTORE_NAME_ATTRIBUTE.isDefined(node)) {
            ssl.setKeystoreFilename(Element.SSL_KETSTORE_NAME_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_KETSTORE_ALIAS_ATTRIBUTE.isDefined(node)) {
            ssl.setKeystorekeyAlias(Element.SSL_KETSTORE_ALIAS_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE.isDefined(node)) {
            ssl.setEnabledCipherSuites(Element.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_KETSTORE_PASSWORD_ATTRIBUTE.isDefined(node)) {
            ssl.setKeystorePassword(Element.SSL_KETSTORE_PASSWORD_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_KETSTORE_TYPE_ATTRIBUTE.isDefined(node)) {
            ssl.setKeystoreType(Element.SSL_KETSTORE_TYPE_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_TRUSTSTORE_NAME_ATTRIBUTE.isDefined(node)) {
            ssl.setTruststoreFilename(Element.SSL_TRUSTSTORE_NAME_ATTRIBUTE.asString(node, context));
        }
        if (Element.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE.isDefined(node)) {
            ssl.setTruststorePassword(Element.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE.asString(node, context));
        }
        socket.setSSLConfiguration(ssl);
        return socket;
    }

    public static void registerReadWriteAttributes(ManagementResourceRegistration subsystem) {
        for (int i = 0; i < attributes.length; ++i) {
            subsystem.registerReadWriteAttribute(attributes[i].getModelName(), null, (OperationStepHandler)AttributeWrite.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
    }
}

