/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.TeiidServiceNames;

class ListVDBs
extends BaseOperationHandler<VDBRepository> {
    protected ListVDBs() {
        super("list-vdbs");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        List vdbs = repo.getVDBs();
        for (VDBMetaData vdb : vdbs) {
            VDBMetadataMapper.INSTANCE.wrap(vdb, result.add());
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        VDBMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

