/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TeiidServiceNames;

class MarkDataSourceAvailable
extends TeiidOperationHandler {
    protected MarkDataSourceAvailable() {
        super("mark-datasource-available");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("ds-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("ds-name.missing")));
        }
        String dsName = operation.get("ds-name").asString();
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_STATUS_CHECKER);
        VDBStatusChecker vsc = (VDBStatusChecker)VDBStatusChecker.class.cast(sc.getValue());
        vsc.dataSourceAdded(dsName, null);
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "ds-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "ds-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "ds-name", "description"}).set(this.getParameterDescription(bundle, "ds-name"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

