/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.teiid.adminapi.AdminException;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;

abstract class TeiidOperationHandler
extends BaseOperationHandler<DQPCore> {
    List<TransportService> transports = new ArrayList<TransportService>();
    protected VDBRepository vdbRepo;
    protected DQPCore engine;
    protected BufferManagerService bufferMgrSvc;

    protected TeiidOperationHandler(String operationName) {
        super(operationName);
    }

    @Override
    protected DQPCore getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        this.transports.clear();
        this.vdbRepo = null;
        this.engine = null;
        this.bufferMgrSvc = null;
        List services = context.getServiceRegistry(false).getServiceNames();
        for (ServiceName name : services) {
            ServiceController transport;
            if (!TeiidServiceNames.TRANSPORT_BASE.isParentOf(name) || (transport = context.getServiceRegistry(false).getService(name)) == null) continue;
            this.transports.add((TransportService)TransportService.class.cast(transport.getValue()));
        }
        ServiceController repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        if (repo != null) {
            this.vdbRepo = (VDBRepository)VDBRepository.class.cast(repo.getValue());
        }
        if ((repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.BUFFER_MGR)) != null) {
            this.bufferMgrSvc = (BufferManagerService)((Object)BufferManagerService.class.cast(repo.getService()));
        }
        if ((repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.ENGINE)) != null) {
            this.engine = (DQPCore)DQPCore.class.cast(repo.getValue());
        }
        return this.engine;
    }

    int getSessionCount() throws AdminException {
        int count = 0;
        for (TransportService t : this.transports) {
            count += t.getActiveSessionsCount();
        }
        return count;
    }
}

