/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ModelController;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.rest.ResteasyEnabler;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.runtime.AbstractVDBDeployer;
import org.teiid.translator.DelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

class VDBService
extends AbstractVDBDeployer
implements Service<RuntimeVDB> {
    private VDBMetaData vdb;
    private RuntimeVDB runtimeVDB;
    protected final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    protected final InjectedValue<TranslatorRepository> translatorRepositoryInjector = new InjectedValue();
    protected final InjectedValue<Executor> executorInjector = new InjectedValue();
    protected final InjectedValue<ObjectSerializer> serializerInjector = new InjectedValue();
    protected final InjectedValue<BufferManager> bufferManagerInjector = new InjectedValue();
    protected final InjectedValue<ObjectReplicator> objectReplicatorInjector = new InjectedValue();
    protected final InjectedValue<VDBStatusChecker> vdbStatusCheckInjector = new InjectedValue();
    protected final InjectedValue<ModelController> controllerValue = new InjectedValue();
    private VDBLifeCycleListener vdbListener;
    private VDBLifeCycleListener restEasyListener;
    private LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap;

    public VDBService(VDBMetaData metadata, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap) {
        this.vdb = metadata;
        this.visibilityMap = visibilityMap;
    }

    public void start(StartContext context) throws StartException {
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        TranslatorRepository repo = new TranslatorRepository();
        this.vdb.addAttchment(TranslatorRepository.class, (Object)repo);
        UDFMetaData udf = (UDFMetaData)this.vdb.getAttachment(UDFMetaData.class);
        for (Translator t : this.vdb.getOverrideTranslators()) {
            VDBTranslatorMetaData data = (VDBTranslatorMetaData)t;
            String type = data.getType();
            VDBTranslatorMetaData parent = this.getTranslatorRepository().getTranslatorMetaData(type);
            data.setModuleName(parent.getModuleName());
            data.addAttchment(ClassLoader.class, parent.getAttachment(ClassLoader.class));
            Set<String> keys = parent.getProperties().stringPropertyNames();
            for (String key : keys) {
                if (data.getPropertyValue(key) != null || parent.getPropertyValue(key) == null) continue;
                data.addProperty(key, parent.getPropertyValue(key));
            }
            repo.addTranslatorMetadata(data.getName(), data);
        }
        this.createConnectorManagers(cmr, repo, this.vdb);
        final ServiceBuilder<Void> vdbService = this.addVDBFinishedService(context);
        this.vdbListener = new VDBLifeCycleListener(){

            public void added(String name, int version, CompositeVDB cvdb) {
            }

            public void removed(String name, int version, CompositeVDB cvdb) {
            }

            public void finishedDeployment(String name, int version, CompositeVDB cvdb) {
                if (!name.equals(VDBService.this.vdb.getName()) || version != VDBService.this.vdb.getVersion()) {
                    return;
                }
                VDBMetaData vdbInstance = cvdb.getVDB();
                if (vdbInstance.getStatus().equals((Object)VDB.Status.ACTIVE)) {
                    GlobalTableStoreImpl gts = new GlobalTableStoreImpl(VDBService.this.getBuffermanager(), (QueryMetadataInterface)vdbInstance.getAttachment(TransformationMetadata.class));
                    if (VDBService.this.objectReplicatorInjector.getValue() != null) {
                        try {
                            gts = (GlobalTableStore)((ObjectReplicator)VDBService.this.objectReplicatorInjector.getValue()).replicate(name + version, GlobalTableStore.class, (Object)gts, 300000L);
                        }
                        catch (Exception e) {
                            LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50023, new Object[]{gts}));
                        }
                    }
                    vdbInstance.addAttchment(GlobalTableStore.class, (Object)gts);
                    vdbService.install();
                }
            }
        };
        this.getVDBRepository().addListener(this.vdbListener);
        this.restEasyListener = new ResteasyEnabler(this.vdb.getName(), this.vdb.getVersion(), (ModelController)this.controllerValue.getValue(), (Executor)this.executorInjector.getValue());
        this.getVDBRepository().addListener(this.restEasyListener);
        MetadataStore store = new MetadataStore();
        try {
            this.assignMetadataRepositories(this.vdb, super.getMetadataRepository("index"));
            this.getVDBRepository().addVDB(this.vdb, store, this.visibilityMap, udf, cmr);
        }
        catch (VirtualDatabaseException e) {
            throw new StartException((Throwable)e);
        }
        this.vdb.removeAttachment(UDFMetaData.class);
        try {
            this.loadMetadata(this.vdb, cmr, store);
        }
        catch (TranslatorException e) {
            throw new StartException((Throwable)e);
        }
        this.runtimeVDB = this.buildRuntimeVDB(this.vdb, context.getController().getServiceContainer());
    }

    private RuntimeVDB buildRuntimeVDB(final VDBMetaData vdbMetadata, final ServiceContainer serviceContainer) {
        RuntimeVDB.VDBModificationListener modificationListener = new RuntimeVDB.VDBModificationListener(){

            public void dataRoleChanged(String policyName) throws AdminProcessingException {
                VDBService.this.save();
            }

            public void connectionTypeChanged() throws AdminProcessingException {
                VDBService.this.save();
            }

            public void dataSourceChanged(String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
                VDBService.this.save();
            }

            public void onRestart(List<String> modelNames) {
                ServiceController switchSvc = serviceContainer.getService(TeiidServiceNames.vdbSwitchServiceName(vdbMetadata.getName(), vdbMetadata.getVersion()));
                if (switchSvc != null) {
                    if (!modelNames.isEmpty()) {
                        for (String model : modelNames) {
                            VDBService.this.deleteModelCache(model);
                        }
                    } else {
                        for (String model : vdbMetadata.getModelMetaDatas().keySet()) {
                            VDBService.this.deleteModelCache(model);
                        }
                    }
                    switchSvc.setMode(ServiceController.Mode.REMOVE);
                }
            }
        };
        return new RuntimeVDB(vdbMetadata, modificationListener){

            protected VDBStatusChecker getVDBStatusChecker() {
                return (VDBStatusChecker)VDBService.this.vdbStatusCheckInjector.getValue();
            }
        };
    }

    Service<Void> createVoidService() {
        return new Service<Void>(){

            public Void getValue() throws IllegalStateException, IllegalArgumentException {
                return null;
            }

            public void start(StartContext sc) throws StartException {
            }

            public void stop(StopContext sc) {
            }
        };
    }

    private ServiceBuilder<Void> addVDBFinishedService(StartContext context) {
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ServiceController controller = serviceContainer.getService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        return serviceContainer.addService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()), this.createVoidService());
    }

    public void stop(StopContext context) {
        ServiceController switchSvc = context.getController().getServiceContainer().getService(TeiidServiceNames.vdbSwitchServiceName(this.vdb.getName(), this.vdb.getVersion()));
        if (switchSvc != null) {
            switchSvc.setMode(ServiceController.Mode.REMOVE);
        }
        if (this.objectReplicatorInjector.getValue() != null) {
            GlobalTableStore gts = (GlobalTableStore)this.vdb.getAttachment(GlobalTableStore.class);
            ((ObjectReplicator)this.objectReplicatorInjector.getValue()).stop((Object)gts);
        }
        this.getVDBRepository().removeVDB(this.vdb.getName(), this.vdb.getVersion());
        this.getVDBRepository().removeListener(this.vdbListener);
        this.getVDBRepository().removeListener(this.restEasyListener);
        ServiceController controller = context.getController().getServiceContainer().getService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50026, new Object[]{this.vdb}));
    }

    public RuntimeVDB getValue() throws IllegalStateException, IllegalArgumentException {
        return this.runtimeVDB;
    }

    private void createConnectorManagers(ConnectorManagerRepository cmr, final TranslatorRepository repo, final VDBMetaData deployment) throws StartException {
        final IdentityHashMap map = new IdentityHashMap();
        try {
            cmr.createConnectorManagers(deployment, new ConnectorManagerRepository.ExecutionFactoryProvider(){

                public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
                    return VDBService.getExecutionFactory(name, repo, VDBService.this.getTranslatorRepository(), deployment, map, new HashSet<String>());
                }
            });
        }
        catch (ConnectorManagerRepository.ConnectorManagerException e) {
            if (e.getCause() != null) {
                throw new StartException(IntegrationPlugin.Event.TEIID50035.name() + " " + e.getMessage(), e.getCause());
            }
            throw new StartException(e.getMessage());
        }
    }

    static ExecutionFactory<Object, Object> getExecutionFactory(String name, TranslatorRepository vdbRepo, TranslatorRepository repo, VDBMetaData deployment, IdentityHashMap<Translator, ExecutionFactory<Object, Object>> map, HashSet<String> building) throws ConnectorManagerRepository.ConnectorManagerException {
        if (!building.add(name)) {
            throw new ConnectorManagerRepository.ConnectorManagerException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50076, new Object[]{deployment.getName(), deployment.getVersion(), building}));
        }
        VDBTranslatorMetaData translator = vdbRepo.getTranslatorMetaData(name);
        if (translator == null) {
            translator = repo.getTranslatorMetaData(name);
        }
        if (translator == null) {
            throw new ConnectorManagerRepository.ConnectorManagerException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50078, new Object[]{deployment.getName(), deployment.getVersion(), name}));
        }
        try {
            ExecutionFactory ef = map.get(translator);
            if (ef == null) {
                DelegatingExecutionFactory delegator;
                String delegateName;
                ClassLoader classloader = (ClassLoader)translator.getAttachment(ClassLoader.class);
                if (classloader == null) {
                    classloader = Thread.currentThread().getContextClassLoader();
                }
                if ((ef = TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)translator, (ClassLoader)classloader)) instanceof DelegatingExecutionFactory && (delegateName = (delegator = (DelegatingExecutionFactory)ef).getDelegateName()) != null) {
                    ExecutionFactory<Object, Object> delegate = VDBService.getExecutionFactory(delegateName, vdbRepo, repo, deployment, map, building);
                    ((DelegatingExecutionFactory)ef).setDelegate(delegate);
                }
                map.put((Translator)translator, (ExecutionFactory<Object, Object>)ef);
            }
            return ef;
        }
        catch (TeiidException e) {
            throw new ConnectorManagerRepository.ConnectorManagerException((Throwable)e);
        }
    }

    protected void loadMetadata(final VDBMetaData vdb, final ModelMetaData model, final ConnectorManagerRepository cmr, final MetadataRepository metadataRepo, final MetadataStore vdbMetadataStore, final AtomicInteger loadCount) {
        String msg = IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50029, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())});
        model.addRuntimeMessage(ModelMetaData.Message.Severity.INFO, msg);
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
        Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean cached = false;
                Exception ex = null;
                Map datatypes = VDBService.this.getVDBRepository().getRuntimeTypeMap();
                NavigableMap builtin = VDBService.this.getVDBRepository().getSystemStore().getDatatypes();
                File cachedFile = VDBService.this.getSerializer().buildModelFile(vdb, model.getName());
                MetadataFactory factory = VDBService.this.getSerializer().loadSafe(cachedFile, MetadataFactory.class);
                if (factory != null) {
                    factory.correctDatatypes(datatypes, (Map)builtin);
                    cached = true;
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " was loaded from cached metadata"});
                } else {
                    factory = VDBService.this.createMetadataFactory(vdb, model);
                    ExecutionFactory ef = null;
                    Object cf = null;
                    try {
                        ConnectorManager cm = VDBService.this.getConnectorManager(model, cmr);
                        if (cm != null) {
                            ef = cm.getExecutionFactory();
                            cf = cm.getConnectionFactory();
                        }
                    }
                    catch (TranslatorException e) {
                        // empty catch block
                    }
                    try {
                        metadataRepo.loadMetadata(factory, ef, cf);
                        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50030, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())}));
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                }
                VDBMetaData vDBMetaData = vdb;
                synchronized (vDBMetaData) {
                    if (ex == null) {
                        if (!cached) {
                            VDBService.this.cacheMetadataStore(model, factory);
                        }
                        VDBService.this.metadataLoaded(vdb, model, vdbMetadataStore, loadCount, factory, true);
                    } else {
                        model.addRuntimeError(ex.getMessage());
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)(ex instanceof RuntimeException && !(ex instanceof TeiidRuntimeException) ? ex : null), (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50036, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), ex.getMessage()}));
                        if (ex instanceof RuntimeException) {
                            VDBService.this.metadataLoaded(vdb, model, vdbMetadataStore, loadCount, factory, false);
                        } else {
                            model.addAttchment(Runnable.class, (Object)this);
                        }
                    }
                }
            }
        };
        Executor executor = this.getExecutor();
        if (executor == null) {
            job.run();
        } else {
            executor.execute(job);
        }
    }

    private void cacheMetadataStore(ModelMetaData model, MetadataFactory schema) {
        boolean cache;
        boolean bl = cache = !this.vdb.isDynamic();
        if (this.vdb.isDynamic()) {
            cache = "cached".equalsIgnoreCase(this.vdb.getPropertyValue("UseConnectorMetadata"));
        }
        if (cache) {
            File cachedFile = this.getSerializer().buildModelFile(this.vdb, model.getName());
            try {
                this.getSerializer().saveAttachment(cachedFile, schema, false);
            }
            catch (IOException e) {
                LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50044, new Object[]{this.vdb.getName(), this.vdb.getVersion(), model.getName()}));
            }
        }
    }

    private void deleteModelCache(String modelName) {
        File cachedFile = this.getSerializer().buildModelFile(this.vdb, modelName);
        this.getSerializer().removeAttachment(cachedFile);
    }

    protected VDBRepository getVDBRepository() {
        return (VDBRepository)this.vdbRepositoryInjector.getValue();
    }

    private TranslatorRepository getTranslatorRepository() {
        return (TranslatorRepository)this.translatorRepositoryInjector.getValue();
    }

    private Executor getExecutor() {
        return (Executor)this.executorInjector.getValue();
    }

    private ObjectSerializer getSerializer() {
        return (ObjectSerializer)this.serializerInjector.getValue();
    }

    private BufferManager getBuffermanager() {
        return (BufferManager)this.bufferManagerInjector.getValue();
    }

    private void save() throws AdminProcessingException {
        try {
            ObjectSerializer os = this.getSerializer();
            VDBMetadataParser.marshell((VDBMetaData)this.vdb, (OutputStream)os.getVdbXmlOutputStream(this.vdb));
        }
        catch (IOException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50048, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50049, (Throwable)e);
        }
    }

    protected MetadataRepository<?, ?> getMetadataRepository(String repoType) throws VirtualDatabaseException {
        Iterator<MetadataRepository> i$;
        ServiceLoader<MetadataRepository> serviceLoader;
        MetadataRepository repo = super.getMetadataRepository(repoType);
        if (repo != null) {
            return repo;
        }
        ClassLoader moduleLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ModuleLoader ml = Module.getCallerModuleLoader();
        if (repoType != null && ml != null) {
            try {
                Module module = ml.loadModule(ModuleIdentifier.create((String)repoType));
                moduleLoader = module.getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw new VirtualDatabaseException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50057, new Object[]{repoType}));
            }
        }
        if ((serviceLoader = ServiceLoader.load(MetadataRepository.class, moduleLoader)) != null && (i$ = serviceLoader.iterator()).hasNext()) {
            MetadataRepository loader = i$.next();
            MetadataRepository old = this.repositories.putIfAbsent(repoType, loader);
            return old != null ? old : loader;
        }
        return null;
    }
}

