/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.EngineStatisticsMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.TeiidOperationHandler;

class EngineStatistics
extends TeiidOperationHandler {
    protected EngineStatistics() {
        super("engine-statistics");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        EngineStatisticsMetadata stats = new EngineStatisticsMetadata();
        try {
            stats.setSessionCount(this.getSessionCount());
            stats.setTotalMemoryUsedInKB(this.bufferMgrSvc.getHeapCacheMemoryInUseKB());
            stats.setMemoryUsedByActivePlansInKB(this.bufferMgrSvc.getHeapMemoryInUseByActivePlansKB());
            stats.setDiskWriteCount(this.bufferMgrSvc.getDiskWriteCount());
            stats.setDiskReadCount(this.bufferMgrSvc.getDiskReadCount());
            stats.setCacheReadCount(this.bufferMgrSvc.getCacheReadCount());
            stats.setCacheWriteCount(this.bufferMgrSvc.getCacheWriteCount());
            stats.setDiskSpaceUsedInMB(this.bufferMgrSvc.getUsedDiskBufferSpaceMB());
            stats.setActivePlanCount(this.engine.getActivePlanCount());
            stats.setWaitPlanCount(this.engine.getWaitingPlanCount());
            stats.setMaxWaitPlanWaterMark(this.engine.getMaxWaitingPlanWatermark());
            VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.wrap(stats, context.getResult());
        }
        catch (AdminException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.OBJECT);
        VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

